/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kathra.platform.model.KathraEnvironmentResourceParameter;

@ApiModel(description="Represents a service")
public class Service {
    private String name;
    private String url;
    private String version;
    private List<String> categories;
    private String licence;
    private String id;
    private String teaser;
    private String description;
    private String website;
    private Status status;
    private String icon;
    private List<KathraEnvironmentResourceParameter> parameters;
    private Map<String, KathraEnvironmentResourceParameter> parameterIndex = new HashMap<String, KathraEnvironmentResourceParameter>();

    public Service() {
    }

    public Service(String name, List<KathraEnvironmentResourceParameter> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public Service(String name) {
        this.name = name;
    }

    public Service(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public Service(String name, String url, String version) {
        this.name = name;
        this.url = url;
        this.version = version;
    }

    @ApiModelProperty(value="Url of the service")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(value="The name of the Service", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The version of the Service")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(value="The categories of the Service")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    @ApiModelProperty(value="The shortened description of the Service")
    public String getTeaser() {
        return this.teaser;
    }

    public void setTeaser(String teaser) {
        this.teaser = teaser;
    }

    @ApiModelProperty(value="The full description of the Service")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The vendor website of the Service")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    @ApiModelProperty(value="The shortened description of the Service")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="Parameters", required=true)
    public List<KathraEnvironmentResourceParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<KathraEnvironmentResourceParameter> parameters) {
        this.parameters = parameters;
        parameters.forEach(param -> this.parameterIndex.put(param.getName(), (KathraEnvironmentResourceParameter)param));
    }

    @ApiModelProperty(value="The service's status")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @ApiModelProperty(value="The service's icon url")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @ApiModelProperty(value="The service's licence")
    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String _licence) {
        this.licence = _licence;
    }

    public KathraEnvironmentResourceParameter getParameter(String name) {
        return this.parameterIndex.get(name);
    }

    public Service name(String name) {
        this.name = name;
        return this;
    }

    public Service url(String url) {
        this.url = url;
        return this;
    }

    public Service version(String version) {
        this.version = version;
        return this;
    }

    public Service license(String licence) {
        this.licence = licence;
        return this;
    }

    public Service id(String id) {
        this.id = id;
        return this;
    }

    public Service teaser(String teaser) {
        this.teaser = teaser;
        return this;
    }

    public Service description(String description) {
        this.description = description;
        return this;
    }

    public Service website(String website) {
        this.website = website;
        return this;
    }

    public Service status(Status status) {
        this.status = status;
        return this;
    }

    public Service icon(String icon) {
        this.icon = icon;
        return this;
    }

    public static enum Status {
        DEPLOYING,
        AVAILABLE,
        DELETING,
        FAILSAFE,
        ERROR;

    }
}

