/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.model;

import java.time.Instant;
import java.util.LinkedList;
import java.util.List;

public class Subscriber {
    String username;
    String wsKey;
    Instant lastSeen;
    List<String> subscribedPlatforms = new LinkedList<String>();

    public Subscriber(String username, String wsKey) {
        this.username = username;
        this.wsKey = wsKey;
        this.lastSeen = Instant.now();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWsKey() {
        return this.wsKey;
    }

    public void setWsKey(String wsKey) {
        this.wsKey = wsKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String pfName) {
        List<String> list = this.subscribedPlatforms;
        synchronized (list) {
            this.subscribedPlatforms.add(pfName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(String pfName) {
        List<String> list = this.subscribedPlatforms;
        synchronized (list) {
            this.subscribedPlatforms.remove(pfName);
        }
    }

    public Instant getLastSeen() {
        return this.lastSeen;
    }

    public List<String> getSubscribedPlatforms() {
        return this.subscribedPlatforms;
    }

    public void updateLastSeen() {
        this.lastSeen = Instant.now();
    }
}

