/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.model;

import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kathra.model.Service;
import org.kathra.platform.model.KathraCatalogResourceParameter;

public class Template {
    private String name;
    List<Service> services;
    private List<KathraCatalogResourceParameter> parameters;
    private Map<String, Service> serviceIndex = new HashMap<String, Service>();
    private Map<String, KathraCatalogResourceParameter> parameterIndex = new HashMap<String, KathraCatalogResourceParameter>();

    public Template() {
    }

    public Template(String name) {
        this.name = name;
    }

    public Template(String name, List<KathraCatalogResourceParameter> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public Service getService(String serviceName) {
        return this.serviceIndex.get(serviceName);
    }

    public void setServices(List<Service> services) {
        this.services = services;
        services.forEach(service -> this.serviceIndex.put(service.getName(), (Service)service));
    }

    @ApiModelProperty(value="Services in the template", required=true)
    public List<Service> getServices() {
        return this.services;
    }

    @ApiModelProperty(value="Name of the template", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Parameters", required=true)
    public List<KathraCatalogResourceParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<KathraCatalogResourceParameter> parameters) {
        this.parameters = parameters;
        parameters.forEach(param -> this.parameterIndex.put(param.getName(), (KathraCatalogResourceParameter)param));
    }

    public KathraCatalogResourceParameter getParameter(String name) {
        return this.parameterIndex.get(name);
    }
}

