/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.apiversion.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.ApiVersion;
import org.kathra.resourcemanager.apiversion.dao.ApiVersionDb;
import org.kathra.resourcemanager.apiversion.dao.ApiVersionMapper;
import org.kathra.resourcemanager.apiversion.dao.ApiVersionRepository;
import org.kathra.resourcemanager.component.dao.ComponentApiVersionEdge;
import org.kathra.resourcemanager.component.dao.ComponentApiVersionEdgeRepository;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionApiVersionEdge;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionApiVersionEdgeRepository;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionDb;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionApiVersionEdge;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionApiVersionEdgeRepository;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionDb;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractApiVersionDao
extends AbstractResourceDao<ApiVersion, ApiVersionDb, String> {
    @Autowired
    ComponentApiVersionEdgeRepository componentApiVersionEdgeRepository;
    @Autowired
    LibraryApiVersionApiVersionEdgeRepository libraryApiVersionApiVersionEdgeRepository;
    @Autowired
    ImplementationVersionApiVersionEdgeRepository implementationVersionApiVersionEdgeRepository;
    ApiVersionMapper mapper = (ApiVersionMapper)Selma.mapper(ApiVersionMapper.class);

    public AbstractApiVersionDao(@Autowired ApiVersionRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new ApiVersionDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.componentApiVersionEdgeRepository.count();
        this.libraryApiVersionApiVersionEdgeRepository.count();
        this.implementationVersionApiVersionEdgeRepository.count();
    }

    @Override
    public void create(ApiVersion object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(ApiVersion object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(ApiVersion object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(ApiVersion object) throws Exception {
        ApiVersionDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(ComponentApiVersionEdge.class).updateReference(resourceDb, "component", (CrudRepository<ComponentApiVersionEdge, ?>)this.componentApiVersionEdgeRepository);
        if (object.getLibrariesApiVersions() != null) {
            List librariesApiVersionsItemsToUpdate = object.getLibrariesApiVersions().parallelStream().filter(Objects::nonNull).map(i -> new LibraryApiVersionDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(LibraryApiVersionApiVersionEdge.class).updateList(resourceDb, librariesApiVersionsItemsToUpdate, (CrudRepository<LibraryApiVersionApiVersionEdge, ?>)this.libraryApiVersionApiVersionEdgeRepository);
        }
        if (object.getImplementationsVersions() != null) {
            List implementationsVersionsItemsToUpdate = object.getImplementationsVersions().parallelStream().filter(Objects::nonNull).map(i -> new ImplementationVersionDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(ImplementationVersionApiVersionEdge.class).updateList(resourceDb, implementationsVersionsItemsToUpdate, (CrudRepository<ImplementationVersionApiVersionEdge, ?>)this.implementationVersionApiVersionEdgeRepository);
        }
    }

    @Override
    public ApiVersionDb convertResourceToResourceDb(ApiVersion object) {
        return this.mapper.asApiVersionDb(object);
    }

    @Override
    public ApiVersion convertResourceDbToResource(ApiVersionDb object) {
        LeanResourceDbUtils<ApiVersionDb> leanResourceDbUtils = new LeanResourceDbUtils<ApiVersionDb>();
        return this.mapper.asApiVersion(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<ApiVersion> convertResourceDbToResource(Stream<ApiVersionDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asApiVersion((ApiVersionDb)i));
    }
}

