/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.group.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.Group;
import org.kathra.resourcemanager.assignation.dao.AssignationDb;
import org.kathra.resourcemanager.binaryrepository.dao.BinaryRepositoryDb;
import org.kathra.resourcemanager.group.dao.GroupAssignationEdge;
import org.kathra.resourcemanager.group.dao.GroupAssignationEdgeRepository;
import org.kathra.resourcemanager.group.dao.GroupBinaryRepositoryEdge;
import org.kathra.resourcemanager.group.dao.GroupBinaryRepositoryEdgeRepository;
import org.kathra.resourcemanager.group.dao.GroupDb;
import org.kathra.resourcemanager.group.dao.GroupGroupEdge;
import org.kathra.resourcemanager.group.dao.GroupGroupEdgeRepository;
import org.kathra.resourcemanager.group.dao.GroupMapper;
import org.kathra.resourcemanager.group.dao.GroupRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.user.dao.UserGroupEdge;
import org.kathra.resourcemanager.user.dao.UserGroupEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractGroupDao
extends AbstractResourceDao<Group, GroupDb, String> {
    @Autowired
    UserGroupEdgeRepository userGroupEdgeRepository;
    @Autowired
    GroupBinaryRepositoryEdgeRepository groupBinaryRepositoryEdgeRepository;
    @Autowired
    GroupAssignationEdgeRepository groupAssignationEdgeRepository;
    @Autowired
    GroupGroupEdgeRepository groupGroupEdgeRepository;
    GroupMapper mapper = (GroupMapper)Selma.mapper(GroupMapper.class);

    public AbstractGroupDao(@Autowired GroupRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new GroupDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.userGroupEdgeRepository.count();
        this.groupBinaryRepositoryEdgeRepository.count();
        this.groupAssignationEdgeRepository.count();
        this.groupGroupEdgeRepository.count();
    }

    @Override
    public void create(Group object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(Group object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(Group object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(Group object) throws Exception {
        GroupDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(UserGroupEdge.class).updateReference(resourceDb, "technicalUser", (CrudRepository<UserGroupEdge, ?>)this.userGroupEdgeRepository);
        if (object.getBinaryRepositories() != null) {
            List binaryRepositoriesItemsToUpdate = object.getBinaryRepositories().parallelStream().filter(Objects::nonNull).map(i -> new BinaryRepositoryDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(GroupBinaryRepositoryEdge.class).updateList(resourceDb, binaryRepositoriesItemsToUpdate, (CrudRepository<GroupBinaryRepositoryEdge, ?>)this.groupBinaryRepositoryEdgeRepository);
        }
        if (object.getMembers() != null) {
            List membersItemsToUpdate = object.getMembers().parallelStream().filter(Objects::nonNull).map(i -> new AssignationDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(GroupAssignationEdge.class).updateList(resourceDb, membersItemsToUpdate, (CrudRepository<GroupAssignationEdge, ?>)this.groupAssignationEdgeRepository);
        }
        EdgeUtils.of(GroupGroupEdge.class).updateReference(resourceDb, "parent", (CrudRepository<GroupGroupEdge, ?>)this.groupGroupEdgeRepository);
    }

    @Override
    public GroupDb convertResourceToResourceDb(Group object) {
        return this.mapper.asGroupDb(object);
    }

    @Override
    public Group convertResourceDbToResource(GroupDb object) {
        LeanResourceDbUtils<GroupDb> leanResourceDbUtils = new LeanResourceDbUtils<GroupDb>();
        return this.mapper.asGroup(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<Group> convertResourceDbToResource(Stream<GroupDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asGroup((GroupDb)i));
    }
}

