/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.implementation.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.Implementation;
import org.kathra.resourcemanager.catalogentry.dao.CatalogEntryDb;
import org.kathra.resourcemanager.implementation.dao.ImplementationBinaryRepositoryEdge;
import org.kathra.resourcemanager.implementation.dao.ImplementationBinaryRepositoryEdgeRepository;
import org.kathra.resourcemanager.implementation.dao.ImplementationCatalogEntryEdge;
import org.kathra.resourcemanager.implementation.dao.ImplementationCatalogEntryEdgeRepository;
import org.kathra.resourcemanager.implementation.dao.ImplementationComponentEdge;
import org.kathra.resourcemanager.implementation.dao.ImplementationComponentEdgeRepository;
import org.kathra.resourcemanager.implementation.dao.ImplementationDb;
import org.kathra.resourcemanager.implementation.dao.ImplementationMapper;
import org.kathra.resourcemanager.implementation.dao.ImplementationRepository;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionDb;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionImplementationEdge;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionImplementationEdgeRepository;
import org.kathra.resourcemanager.pipeline.dao.PipelineImplementationEdge;
import org.kathra.resourcemanager.pipeline.dao.PipelineImplementationEdgeRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryImplementationEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryImplementationEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractImplementationDao
extends AbstractResourceDao<Implementation, ImplementationDb, String> {
    @Autowired
    ImplementationComponentEdgeRepository implementationComponentEdgeRepository;
    @Autowired
    ImplementationVersionImplementationEdgeRepository implementationVersionImplementationEdgeRepository;
    @Autowired
    ImplementationCatalogEntryEdgeRepository implementationCatalogEntryEdgeRepository;
    @Autowired
    ImplementationBinaryRepositoryEdgeRepository implementationBinaryRepositoryEdgeRepository;
    @Autowired
    SourceRepositoryImplementationEdgeRepository sourceRepositoryImplementationEdgeRepository;
    @Autowired
    PipelineImplementationEdgeRepository pipelineImplementationEdgeRepository;
    ImplementationMapper mapper = (ImplementationMapper)Selma.mapper(ImplementationMapper.class);

    public AbstractImplementationDao(@Autowired ImplementationRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new ImplementationDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.implementationComponentEdgeRepository.count();
        this.implementationVersionImplementationEdgeRepository.count();
        this.implementationCatalogEntryEdgeRepository.count();
        this.implementationBinaryRepositoryEdgeRepository.count();
        this.sourceRepositoryImplementationEdgeRepository.count();
        this.pipelineImplementationEdgeRepository.count();
    }

    @Override
    public void create(Implementation object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(Implementation object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(Implementation object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(Implementation object) throws Exception {
        ImplementationDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(ImplementationComponentEdge.class).updateReference(resourceDb, "component", (CrudRepository<ImplementationComponentEdge, ?>)this.implementationComponentEdgeRepository);
        if (object.getVersions() != null) {
            List versionsItemsToUpdate = object.getVersions().parallelStream().filter(Objects::nonNull).map(i -> new ImplementationVersionDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(ImplementationVersionImplementationEdge.class).updateList(resourceDb, versionsItemsToUpdate, (CrudRepository<ImplementationVersionImplementationEdge, ?>)this.implementationVersionImplementationEdgeRepository);
        }
        if (object.getCatalogEntries() != null) {
            List catalogEntriesItemsToUpdate = object.getCatalogEntries().parallelStream().filter(Objects::nonNull).map(i -> new CatalogEntryDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(ImplementationCatalogEntryEdge.class).updateList(resourceDb, catalogEntriesItemsToUpdate, (CrudRepository<ImplementationCatalogEntryEdge, ?>)this.implementationCatalogEntryEdgeRepository);
        }
        EdgeUtils.of(ImplementationBinaryRepositoryEdge.class).updateReference(resourceDb, "binaryRepository", (CrudRepository<ImplementationBinaryRepositoryEdge, ?>)this.implementationBinaryRepositoryEdgeRepository);
        EdgeUtils.of(SourceRepositoryImplementationEdge.class).updateReference(resourceDb, "sourceRepository", (CrudRepository<SourceRepositoryImplementationEdge, ?>)this.sourceRepositoryImplementationEdgeRepository);
        EdgeUtils.of(PipelineImplementationEdge.class).updateReference(resourceDb, "pipeline", (CrudRepository<PipelineImplementationEdge, ?>)this.pipelineImplementationEdgeRepository);
    }

    @Override
    public ImplementationDb convertResourceToResourceDb(Implementation object) {
        return this.mapper.asImplementationDb(object);
    }

    @Override
    public Implementation convertResourceDbToResource(ImplementationDb object) {
        LeanResourceDbUtils<ImplementationDb> leanResourceDbUtils = new LeanResourceDbUtils<ImplementationDb>();
        return this.mapper.asImplementation(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<Implementation> convertResourceDbToResource(Stream<ImplementationDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asImplementation((ImplementationDb)i));
    }
}

