/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.implementation.service;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import javax.annotation.PostConstruct;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Component;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.resourcemanager.apiversion.service.ApiVersionService;
import org.kathra.resourcemanager.component.service.ComponentService;
import org.kathra.resourcemanager.implementation.dao.ImplementationDao;
import org.kathra.resourcemanager.implementationversion.service.ImplementationVersionService;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.resourcemanager.resource.service.security.ResourceSecured;
import org.kathra.resourcemanager.resource.service.security.ResourceSecuredAction;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImplementationService
extends AbstractService<Implementation, String> {
    @Autowired
    private ImplementationService self = this;
    @Autowired
    ComponentService componentService;
    @Autowired
    ApiVersionService apiVersionService;
    @Autowired
    ImplementationVersionService implementationVersionService;

    public ImplementationService(@Autowired ImplementationDao dao, @Autowired SessionService sessionService) {
        super(dao, sessionService);
    }

    @PostConstruct
    public void init() {
        this.implementationVersionService.setImplementationService(this);
    }

    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Implementation.class, target="output")
    public List<Implementation> getImplementationsByComponent(String componentId) throws Exception {
        HashMap<String, Implementation> implementations = new HashMap<String, Implementation>();
        Component componentWthApiVersions = this.componentService.findById(componentId).orElseThrow(() -> new NotFoundException("Unable to find " + componentId));
        for (ApiVersion apiVersion : componentWthApiVersions.getVersions()) {
            List implementationsVersions = this.apiVersionService.findById(apiVersion.getId()).get().getImplementationsVersions();
            for (ImplementationVersion implementationVersion : implementationsVersions) {
                Implementation implementation = this.implementationVersionService.findById(implementationVersion.getId()).get().getImplementation();
                if (implementations.containsKey(implementation.getId())) continue;
                implementations.put(implementation.getId(), implementation);
            }
        }
        for (Implementation implementation : implementations.values()) {
            implementations.replace(implementation.getId(), this.findById(implementation.getId()).get());
        }
        return implementations.values().stream().collect(Collectors.toList());
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.REGISTER, clazz=Implementation.class, target="object")
    public void create(Implementation object) throws Exception {
        super.create(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.UNREGISTER, clazz=Implementation.class, target="object")
    public void delete(Implementation object) throws Exception {
        super.delete(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object")
    public void update(Implementation object) throws Exception {
        super.update(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object")
    public void patch(Implementation object) throws Exception {
        super.patch(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Implementation.class, target="output")
    public List<Implementation> findAll() throws Exception {
        List<String> ids = this.self.findAllIdsAuthorized();
        return this.serviceDao.findAll(ids);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.READ}, clazz=Implementation.class, target="id")
    public Optional<Implementation> findById(String id) throws Exception {
        return super.findById(id);
    }

    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Implementation.class, target="output")
    public List<String> findAllIdsAuthorized() throws Exception {
        return this.serviceDao.findAllIdentifiers();
    }
}

