/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.implementationversion.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionApiVersionEdge;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionApiVersionEdgeRepository;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionDb;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionImplementationEdge;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionImplementationEdgeRepository;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionMapper;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryImplementationVersionEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryImplementationVersionEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractImplementationVersionDao
extends AbstractResourceDao<ImplementationVersion, ImplementationVersionDb, String> {
    @Autowired
    SourceRepositoryImplementationVersionEdgeRepository sourceRepositoryImplementationVersionEdgeRepository;
    @Autowired
    ImplementationVersionImplementationEdgeRepository implementationVersionImplementationEdgeRepository;
    @Autowired
    ImplementationVersionApiVersionEdgeRepository implementationVersionApiVersionEdgeRepository;
    ImplementationVersionMapper mapper = (ImplementationVersionMapper)Selma.mapper(ImplementationVersionMapper.class);

    public AbstractImplementationVersionDao(@Autowired ImplementationVersionRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new ImplementationVersionDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sourceRepositoryImplementationVersionEdgeRepository.count();
        this.implementationVersionImplementationEdgeRepository.count();
        this.implementationVersionApiVersionEdgeRepository.count();
    }

    @Override
    public void create(ImplementationVersion object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(ImplementationVersion object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(ImplementationVersion object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(ImplementationVersion object) throws Exception {
        ImplementationVersionDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(SourceRepositoryImplementationVersionEdge.class).updateReference(resourceDb, "sourceRepo", (CrudRepository<SourceRepositoryImplementationVersionEdge, ?>)this.sourceRepositoryImplementationVersionEdgeRepository);
        EdgeUtils.of(ImplementationVersionImplementationEdge.class).updateReference(resourceDb, "implementation", (CrudRepository<ImplementationVersionImplementationEdge, ?>)this.implementationVersionImplementationEdgeRepository);
        EdgeUtils.of(ImplementationVersionApiVersionEdge.class).updateReference(resourceDb, "apiVersion", (CrudRepository<ImplementationVersionApiVersionEdge, ?>)this.implementationVersionApiVersionEdgeRepository);
    }

    @Override
    public ImplementationVersionDb convertResourceToResourceDb(ImplementationVersion object) {
        return this.mapper.asImplementationVersionDb(object);
    }

    @Override
    public ImplementationVersion convertResourceDbToResource(ImplementationVersionDb object) {
        LeanResourceDbUtils<ImplementationVersionDb> leanResourceDbUtils = new LeanResourceDbUtils<ImplementationVersionDb>();
        return this.mapper.asImplementationVersion(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<ImplementationVersion> convertResourceDbToResource(Stream<ImplementationVersionDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asImplementationVersion((ImplementationVersionDb)i));
    }
}

