/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.implementationversion.service;

import java.util.List;
import java.util.Optional;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.resourcemanager.implementation.service.ImplementationService;
import org.kathra.resourcemanager.implementationversion.dao.ImplementationVersionDao;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.resourcemanager.resource.service.security.ResourceSecured;
import org.kathra.resourcemanager.resource.service.security.ResourceSecuredAction;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImplementationVersionService
extends AbstractService<ImplementationVersion, String> {
    ImplementationService implementationService;

    public ImplementationVersionService(@Autowired ImplementationVersionDao dao, @Autowired SessionService sessionService, ImplementationService implementationService) {
        super(dao, sessionService);
        this.implementationService = implementationService;
    }

    public ImplementationService getImplementationService() {
        return this.implementationService;
    }

    public void setImplementationService(ImplementationService implementationService) {
        this.implementationService = implementationService;
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object/implementation")
    public void create(ImplementationVersion object) throws Exception {
        super.create(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object/implementation")
    public void delete(ImplementationVersion object) throws Exception {
        super.delete(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object/implementation")
    public void update(ImplementationVersion object) throws Exception {
        super.update(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Implementation.class, target="object/implementation")
    public void patch(ImplementationVersion object) throws Exception {
        super.patch(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Implementation.class, target="output/implementation")
    public List<ImplementationVersion> findAll() throws Exception {
        return this.serviceDao.findAll(this.findAllIdsAuthorized());
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.READ}, clazz=Implementation.class, target="output/implementation")
    public Optional<ImplementationVersion> findById(String id) {
        return this.serviceDao.findById(id);
    }

    public List<String> findAllIdsAuthorized() throws Exception {
        return ((ImplementationVersionDao)this.serviceDao).findAllByImplementationIds(this.implementationService.findAllIdsAuthorized());
    }
}

