/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.keypair.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.KeyPair;
import org.kathra.resourcemanager.keypair.dao.KeyPairDb;
import org.kathra.resourcemanager.keypair.dao.KeyPairGroupEdge;
import org.kathra.resourcemanager.keypair.dao.KeyPairGroupEdgeRepository;
import org.kathra.resourcemanager.keypair.dao.KeyPairMapper;
import org.kathra.resourcemanager.keypair.dao.KeyPairRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractKeyPairDao
extends AbstractResourceDao<KeyPair, KeyPairDb, String> {
    @Autowired
    KeyPairGroupEdgeRepository keyPairGroupEdgeRepository;
    KeyPairMapper mapper = (KeyPairMapper)Selma.mapper(KeyPairMapper.class);

    public AbstractKeyPairDao(@Autowired KeyPairRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new KeyPairDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.keyPairGroupEdgeRepository.count();
    }

    @Override
    public void create(KeyPair object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(KeyPair object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(KeyPair object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(KeyPair object) throws Exception {
        KeyPairDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(KeyPairGroupEdge.class).updateReference(resourceDb, "group", (CrudRepository<KeyPairGroupEdge, ?>)this.keyPairGroupEdgeRepository);
    }

    @Override
    public KeyPairDb convertResourceToResourceDb(KeyPair object) {
        return this.mapper.asKeyPairDb(object);
    }

    @Override
    public KeyPair convertResourceDbToResource(KeyPairDb object) {
        LeanResourceDbUtils<KeyPairDb> leanResourceDbUtils = new LeanResourceDbUtils<KeyPairDb>();
        return this.mapper.asKeyPair(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<KeyPair> convertResourceDbToResource(Stream<KeyPairDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asKeyPair((KeyPairDb)i));
    }
}

