/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.pipeline.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.Pipeline;
import org.kathra.resourcemanager.pipeline.dao.PipelineDb;
import org.kathra.resourcemanager.pipeline.dao.PipelineMapper;
import org.kathra.resourcemanager.pipeline.dao.PipelineRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryPipelineEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryPipelineEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractPipelineDao
extends AbstractResourceDao<Pipeline, PipelineDb, String> {
    @Autowired
    SourceRepositoryPipelineEdgeRepository sourceRepositoryPipelineEdgeRepository;
    PipelineMapper mapper = (PipelineMapper)Selma.mapper(PipelineMapper.class);

    public AbstractPipelineDao(@Autowired PipelineRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new PipelineDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sourceRepositoryPipelineEdgeRepository.count();
    }

    @Override
    public void create(Pipeline object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(Pipeline object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(Pipeline object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(Pipeline object) throws Exception {
        PipelineDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(SourceRepositoryPipelineEdge.class).updateReference(resourceDb, "sourceRepository", (CrudRepository<SourceRepositoryPipelineEdge, ?>)this.sourceRepositoryPipelineEdgeRepository);
    }

    @Override
    public PipelineDb convertResourceToResourceDb(Pipeline object) {
        return this.mapper.asPipelineDb(object);
    }

    @Override
    public Pipeline convertResourceDbToResource(PipelineDb object) {
        LeanResourceDbUtils<PipelineDb> leanResourceDbUtils = new LeanResourceDbUtils<PipelineDb>();
        return this.mapper.asPipeline(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<Pipeline> convertResourceDbToResource(Stream<PipelineDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asPipeline((PipelineDb)i));
    }
}

