/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.controller;

import java.util.List;
import java.util.UUID;
import javassist.NotFoundException;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.utils.KathraException;

public interface AbstractCrudController<X extends Resource> {
    public AbstractService<X, String> getService();

    default public X get(String resourceId) throws Exception {
        try {
            if (resourceId == null) {
                throw new IllegalArgumentException("identifier is null");
            }
            this.verifyStringIsUUID(resourceId);
            return (X)((Resource)this.getService().findById(resourceId).orElseThrow(() -> new NotFoundException("not found object with id :" + resourceId)));
        }
        catch (Exception e) {
            this.manageException(e);
            return null;
        }
    }

    private void verifyStringIsUUID(String uuidAsString) {
        try {
            UUID.fromString(uuidAsString);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("resourceId malformated : " + uuidAsString);
        }
    }

    default public X add(X object) throws Exception {
        try {
            if (object == null) {
                throw new IllegalArgumentException("object is null");
            }
            this.getService().create(object);
            return this.get(object.getId());
        }
        catch (Exception e) {
            this.manageException(e);
            return null;
        }
    }

    default public void delete(String resourceId) throws Exception {
        try {
            this.verifyStringIsUUID(resourceId);
            this.getService().delete(this.get(resourceId));
        }
        catch (Exception e) {
            this.manageException(e);
        }
    }

    default public List<X> getAll() throws Exception {
        try {
            return this.getService().findAll();
        }
        catch (Exception e) {
            this.manageException(e);
            return null;
        }
    }

    default public X update(String resourceId, X object) throws Exception {
        try {
            if (resourceId == null) {
                throw new IllegalArgumentException("identifier is null");
            }
            this.verifyStringIsUUID(resourceId);
            if (object == null) {
                throw new IllegalArgumentException("object is null");
            }
            object.setId(resourceId);
            this.getService().update(object);
            return this.get(resourceId);
        }
        catch (Exception e) {
            this.manageException(e);
            return null;
        }
    }

    default public X patch(String resourceId, X object) throws Exception {
        try {
            if (resourceId == null) {
                throw new IllegalArgumentException("identifier is null");
            }
            this.verifyStringIsUUID(resourceId);
            if (object == null) {
                throw new IllegalArgumentException("object is null");
            }
            object.setId(resourceId);
            this.getService().patch(object);
            return this.get(resourceId);
        }
        catch (Exception e) {
            this.manageException(e);
            return null;
        }
    }

    default public void manageException(Exception e) throws KathraException {
        if (e instanceof IllegalArgumentException) {
            throw new KathraException(e.getMessage(), (Throwable)e, KathraException.ErrorCode.BAD_REQUEST);
        }
        if (e instanceof IllegalAccessException) {
            throw new KathraException(e.getMessage(), (Throwable)e, KathraException.ErrorCode.UNAUTHORIZED);
        }
        if (e instanceof NotFoundException) {
            throw new KathraException(e.getMessage(), (Throwable)e, KathraException.ErrorCode.NOT_FOUND);
        }
        if (e instanceof KathraException) {
            throw (KathraException)e;
        }
        throw new KathraException(e.getMessage(), (Throwable)e, KathraException.ErrorCode.INTERNAL_SERVER_ERROR);
    }
}

