/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.dao;

import com.arangodb.ArangoCursor;
import com.arangodb.springframework.annotation.Document;
import com.arangodb.springframework.core.ArangoOperations;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.converter.ConverterResourceToResourceDb;
import org.kathra.resourcemanager.resource.dao.IResourceDb;
import org.kathra.resourcemanager.resource.dao.ResourceReference;
import org.modelmapper.ModelMapper;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractResourceDao<X extends Resource, V extends IResourceDb, ID>
implements ConverterResourceToResourceDb<X, V> {
    protected ArangoOperations operations;
    protected CrudRepository<V, ID> repository;
    protected Class<V> clazzResourcedDb = null;

    public AbstractResourceDao(CrudRepository<V, ID> repository, ArangoOperations operations) {
        this.repository = repository;
        this.operations = operations;
        this.initResourcedDbClazz();
        this.initResourceReferenceCollectionIfNotExist();
    }

    private void initResourcedDbClazz() {
        Class<?> clazz = this.getClass();
        do {
            try {
                this.clazzResourcedDb = (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[1];
            }
            catch (Exception e) {
                clazz = this.getClass().getSuperclass();
            }
        } while (!clazz.equals(Object.class) && this.clazzResourcedDb == null);
        if (this.clazzResourcedDb == null) {
            throw new RuntimeException("Unable to find clazz parameter");
        }
    }

    public void initResourceReferenceCollectionIfNotExist() {
        try {
            this.operations.collection(((Document[])ResourceReference.class.getAnnotationsByType(Document.class))[0].value());
        }
        catch (Exception e) {
            this.operations.insert((Object)new ResourceReference("init"));
            this.operations.delete((Object)"init", Resource.class);
            e.printStackTrace();
        }
    }

    public void create(X object, String author) throws Exception {
        Object objectDb = this.convertResourceToResourceDb(object);
        objectDb.setStatus(Resource.StatusEnum.PENDING);
        this.updateCreateAt(objectDb);
        objectDb.setCreatedBy(author);
        objectDb.setId(this.generateIdentifier(objectDb));
        this.operations.insert(objectDb);
        object.setId(objectDb.getId().toString());
        object.setStatus(objectDb.getStatus());
        object.setCreatedAt(Integer.valueOf(Long.valueOf(objectDb.getCreatedAt()).intValue()));
        object.setCreatedBy(author);
    }

    private ID generateIdentifier(V object) {
        String uuid;
        ArangoCursor result;
        int maxAttempt = 5;
        int iAttempt = 0;
        ResourceReference resourceReference = this.getResourceReference(object);
        do {
            if (iAttempt > maxAttempt) {
                throw new RuntimeException("Unable to generate an uuid identifier");
            }
            uuid = UUID.randomUUID().toString();
            result = this.operations.query("FOR doc IN " + ((Document[])ResourceReference.class.getAnnotationsByType(Document.class))[0].value() + " FILTER doc._key == \"" + uuid + "\" RETURN doc", ResourceReference.class);
            ++iAttempt;
        } while (result.count() > 0L);
        resourceReference.uuid = uuid;
        this.operations.insert((Object)resourceReference);
        return (ID)resourceReference.uuid;
    }

    private ResourceReference getResourceReference(V object) {
        ResourceReference resourceReference = (ResourceReference)new ModelMapper().map(object, ResourceReference.class);
        resourceReference.name = object.getName();
        resourceReference.status = object.getStatus();
        resourceReference.type = ((Document[])object.getClass().getAnnotationsByType(Document.class))[0].value();
        resourceReference.createdAt = object.getCreatedAt();
        resourceReference.createdBy = object.getUpdatedBy();
        resourceReference.updatedAt = object.getUpdatedAt();
        resourceReference.updatedBy = object.getUpdatedBy();
        if (object.getId() != null) {
            resourceReference.uuid = object.getId().toString();
        }
        return resourceReference;
    }

    private void updateResourceReference(ResourceReference object) {
        this.operations.update((Object)object.uuid, (Object)object);
    }

    public void delete(X object, String author) throws Exception {
        IResourceDb objectDb = (IResourceDb)this.repository.findById((Object)object.getId()).get();
        this.updateUpdatedAt(objectDb);
        objectDb.setStatus(Resource.StatusEnum.DELETED);
        objectDb.setUpdatedBy(author);
        this.updateResourceReference(this.getResourceReference(objectDb));
        this.repository.save((Object)objectDb);
        object.setStatus(Resource.StatusEnum.DELETED);
        object.setUpdatedAt(Integer.valueOf(Long.valueOf(objectDb.getUpdatedAt()).intValue()));
        object.setUpdatedBy(author);
    }

    public void update(X object, String author) throws Exception {
        Object objectDb = this.convertResourceToResourceDb(object);
        this.updateUpdatedAt(objectDb);
        objectDb.setUpdatedBy(author);
        this.updateResourceReference(this.getResourceReference(objectDb));
        this.repository.save(objectDb);
        object.setUpdatedAt(Integer.valueOf(Long.valueOf(objectDb.getUpdatedAt()).intValue()));
        object.setUpdatedBy(author);
    }

    public List<X> findAll() {
        ArangoCursor results = this.operations.query("FOR doc IN " + this.getDocumentOfResourceDb().value() + " FILTER doc.status != \"" + Resource.StatusEnum.DELETED.toString() + "\" RETURN doc", this.getClassOfResourceDb());
        return this.convertResourceDbToResource(StreamSupport.stream(results.spliterator(), false)).collect(Collectors.toList());
    }

    public List<X> findAll(List<ID> ids) throws Exception {
        ArangoCursor results = this.operations.query("FOR doc IN " + this.getDocumentOfResourceDb().value() + " FILTER doc._key in " + new ObjectMapper().writeValueAsString(ids) + " RETURN doc", this.getClassOfResourceDb());
        return this.convertResourceDbToResource(StreamSupport.stream(results.spliterator(), false)).collect(Collectors.toList());
    }

    public List<ID> findAllIdentifiers() throws Exception {
        return StreamSupport.stream(this.operations.query("FOR doc IN " + this.getDocumentOfResourceDb().value() + " FILTER doc.status != \"" + Resource.StatusEnum.DELETED.toString() + "\" RETURN doc._key", String.class).spliterator(), false).collect(Collectors.toList());
    }

    protected Class<V> getClassOfResourceDb() {
        return this.clazzResourcedDb;
    }

    protected Document getDocumentOfResourceDb() {
        return ((Document[])this.getClassOfResourceDb().getAnnotationsByType(Document.class))[0];
    }

    public Optional<X> findById(ID id) {
        Optional result = this.repository.findById(id);
        return result.isPresent() && (((IResourceDb)result.get()).getStatus() == null || !((IResourceDb)result.get()).getStatus().equals((Object)Resource.StatusEnum.DELETED)) ? Optional.of(this.convertWithLean((IResourceDb)result.get())) : Optional.empty();
    }

    private X convertWithLean(V objectDb) {
        return this.convertResourceDbToResource(objectDb);
    }

    private void updateUpdatedAt(V object) {
        object.setUpdatedAt(System.currentTimeMillis() / 1000L);
    }

    private void updateCreateAt(V object) {
        object.setCreatedAt(System.currentTimeMillis() / 1000L);
    }
}

