/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.service.security;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.kathra.utils.Session;
import org.kathra.utils.security.KeycloakUtils;
import org.springframework.stereotype.Service;

@Service
public class KeycloakClient {
    @PostConstruct
    public void init() {
        try {
            KeycloakUtils.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public List<String> getResourcesByType(Session session, String type, String scopeIdentifier) throws Exception {
        return KeycloakUtils.getResourcesByType((Session)session, (String)type, (String)scopeIdentifier);
    }

    public void createResource(Session session, String type, String id, List<String> scopes, Map<String, String> metadata) throws Exception {
        KeycloakUtils.createResource((Session)session, (String)type, (String)id, scopes, metadata);
    }

    public void deleteResource(Session session, String identifier, String scopeIdentifier) throws Exception {
        KeycloakUtils.deleteResource((Session)session, (String)identifier, (String)scopeIdentifier);
    }

    public void deleteResourceScope(Session session, String identifier, String scopeIdentifier) throws Exception {
        KeycloakUtils.deleteResourceScope((Session)session, (String)identifier, (String)scopeIdentifier);
    }

    public String getResourceById(Session session, String identifier, String scopeIdentifier) throws Exception {
        return KeycloakUtils.getResourceById((Session)session, (String)identifier, (String)scopeIdentifier);
    }
}

