/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.utils;

import com.google.common.collect.ImmutableList;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.kathra.resourcemanager.resource.dao.IResourceDb;

public class LeanResourceDbUtils<X extends IResourceDb> {
    private int deepLevel = 1;
    private ConcurrentHashMap<String, IResourceDb> objectsIdentified = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, PropertyDescriptor[]> propertyDescriptors = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, Constructor> constructors = new ConcurrentHashMap();
    public static ImmutableList<String> propertiesExcluded = ImmutableList.of((Object)"id", (Object)"class", (Object)"name");

    public static <T> LeanResourceDbUtils of(Class<? extends T> clazz) {
        try {
            return (LeanResourceDbUtils)LeanResourceDbUtils.class.getConstructor(clazz).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public X leanResourceDb(X object) {
        return (X)this.leanResourceDb((IResourceDb)object, this.deepLevel);
    }

    private IResourceDb leanResourceDb(IResourceDb object, int level) {
        try {
            if (level == 0) {
                return this.getSimpleResourceDb(object);
            }
            int currentLevel = level - 1;
            PropertyDescriptor[] propertiesDescriptors = propertyDescriptors.get(object.getClass());
            if (propertiesDescriptors == null) {
                propertiesDescriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
                propertyDescriptors.put(object.getClass(), propertiesDescriptors);
            }
            PropertyDescriptor[] propertyDescriptorArray = propertiesDescriptors;
            int n = propertiesDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor.getReadMethod() == null) {
                    throw new Exception("Unable to find getter for property " + propertyDescriptor.getName() + " into class " + object.getClass().getName());
                }
                Object propertyObject = propertyDescriptor.getReadMethod().invoke((Object)object, new Object[0]);
                if (propertyObject != null) {
                    if (IResourceDb.class.isAssignableFrom(propertyObject.getClass())) {
                        propertyDescriptor.getWriteMethod().invoke((Object)object, this.leanResourceDb((IResourceDb)propertyObject, currentLevel));
                    } else if (List.class.isAssignableFrom(propertyObject.getClass())) {
                        List list = (List)propertyObject;
                        ListIterator<IResourceDb> listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            Object item = listIterator.next();
                            if (!(item instanceof IResourceDb)) continue;
                            IResourceDb leanedO = this.leanResourceDb((IResourceDb)item, currentLevel);
                            if (leanedO != null) {
                                listIterator.set(this.leanResourceDb((IResourceDb)item, currentLevel));
                                continue;
                            }
                            listIterator.remove();
                        }
                    } else if (Map.class.isAssignableFrom(propertyObject.getClass())) {
                        for (Map.Entry entry : ((Map)propertyObject).entrySet()) {
                            if (!(entry instanceof Map.Entry)) continue;
                            if (entry.getValue() instanceof IResourceDb) {
                                IResourceDb leanedO = this.leanResourceDb((IResourceDb)entry.getValue(), currentLevel);
                                if (leanedO != null) {
                                    entry.setValue(leanedO);
                                } else {
                                    ((Map)propertyObject).remove(entry.getKey());
                                }
                            }
                            if (!(entry.getKey() instanceof IResourceDb)) continue;
                            IResourceDb newKey = this.leanResourceDb((IResourceDb)entry.getKey(), currentLevel);
                            ((Map)propertyObject).remove(entry.getKey());
                            if (newKey == null) continue;
                            ((Map)propertyObject).put(newKey, entry.getValue());
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    private IResourceDb getSimpleResourceDb(IResourceDb object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String resourceUuid = (String)object.getId();
        if (StringUtils.isEmpty((CharSequence)resourceUuid)) {
            return null;
        }
        IResourceDb objectFound = this.objectsIdentified.get(resourceUuid);
        if (objectFound != null) {
            return objectFound;
        }
        Constructor<?> constructor = constructors.get(object.getClass());
        if (constructor == null) {
            constructor = object.getClass().getConstructor(new Class[0]);
            constructors.put(object.getClass(), constructor);
        }
        IResourceDb newO = (IResourceDb)constructor.newInstance(new Object[0]);
        newO.setId(resourceUuid);
        this.objectsIdentified.put(resourceUuid, newO);
        return newO;
    }
}

