/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.utils;

import com.google.common.collect.ImmutableList;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import org.kathra.core.model.Resource;

public class LeanResourceUtils<X extends Resource> {
    public static ImmutableList<String> propertiesExcluded = ImmutableList.of((Object)"id", (Object)"class", (Object)"name");

    public static <T> LeanResourceUtils of(Class<? extends T> clazz) {
        try {
            return (LeanResourceUtils)LeanResourceUtils.class.getConstructor(clazz).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public X leanObject(X object) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor.getReadMethod() == null) {
                    throw new Exception("Unable to find getter for property " + propertyDescriptor.getName() + " into class " + object.getClass().getName());
                }
                Object propertyObject = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
                if (propertyObject != null) {
                    if (Resource.class.isAssignableFrom(propertyObject.getClass())) {
                        this.cleanExceptObject((Resource)propertyObject);
                    } else if (Iterable.class.isAssignableFrom(propertyObject.getClass())) {
                        Iterator it = ((Iterable)propertyObject).iterator();
                        while (it.hasNext()) {
                            Object item = it.next();
                            if (item == null) {
                                it.remove();
                                continue;
                            }
                            if (!(item instanceof Resource)) continue;
                            this.cleanExceptObject((Resource)item);
                        }
                    } else if (Map.class.isAssignableFrom(propertyObject.getClass())) {
                        for (Map.Entry entry : ((Map)propertyObject).entrySet()) {
                            if (!(entry instanceof Map.Entry)) continue;
                            if (entry.getValue() == null) {
                                ((Map)propertyObject).remove(entry.getKey());
                            } else if (entry.getValue() instanceof Resource) {
                                this.cleanExceptObject((Resource)entry.getValue());
                            }
                            if (!(entry.getKey() instanceof Resource)) continue;
                            this.cleanExceptObject((Resource)entry.getKey());
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to lean object.", e);
        }
        return object;
    }

    private void cleanExceptObject(Resource object) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (!propertiesExcluded.contains((Object)propertyDescriptor.getName())) {
                    propertyDescriptor.getWriteMethod().invoke((Object)object, new Object[1]);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to lean object.", e);
        }
    }
}

