/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.user.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.User;
import org.kathra.resourcemanager.assignation.dao.AssignationDb;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.user.dao.UserAssignationEdge;
import org.kathra.resourcemanager.user.dao.UserAssignationEdgeRepository;
import org.kathra.resourcemanager.user.dao.UserDb;
import org.kathra.resourcemanager.user.dao.UserMapper;
import org.kathra.resourcemanager.user.dao.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractUserDao
extends AbstractResourceDao<User, UserDb, String> {
    @Autowired
    UserAssignationEdgeRepository userAssignationEdgeRepository;
    UserMapper mapper = (UserMapper)Selma.mapper(UserMapper.class);

    public AbstractUserDao(@Autowired UserRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new UserDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.userAssignationEdgeRepository.count();
    }

    @Override
    public void create(User object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(User object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(User object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(User object) throws Exception {
        UserDb resourceDb = this.convertResourceToResourceDb(object);
        if (object.getGroups() != null) {
            List groupsItemsToUpdate = object.getGroups().parallelStream().filter(Objects::nonNull).map(i -> new AssignationDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(UserAssignationEdge.class).updateList(resourceDb, groupsItemsToUpdate, (CrudRepository<UserAssignationEdge, ?>)this.userAssignationEdgeRepository);
        }
    }

    @Override
    public UserDb convertResourceToResourceDb(User object) {
        return this.mapper.asUserDb(object);
    }

    @Override
    public User convertResourceDbToResource(UserDb object) {
        LeanResourceDbUtils<UserDb> leanResourceDbUtils = new LeanResourceDbUtils<UserDb>();
        return this.mapper.asUser(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<User> convertResourceDbToResource(Stream<UserDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asUser((UserDb)i));
    }
}

