/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.apiversion.service;

import java.util.List;
import java.util.Optional;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Component;
import org.kathra.resourcemanager.apiversion.dao.ApiVersionDao;
import org.kathra.resourcemanager.component.service.ComponentService;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.resourcemanager.resource.service.security.ResourceSecured;
import org.kathra.resourcemanager.resource.service.security.ResourceSecuredAction;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiVersionService
extends AbstractService<ApiVersion, String> {
    ComponentService componentService;

    public ApiVersionService(@Autowired ApiVersionDao dao, @Autowired SessionService sessionService, @Autowired ComponentService componentService) {
        super(dao, sessionService);
        this.componentService = componentService;
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object/component")
    public void create(ApiVersion object) throws Exception {
        super.create(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object/component")
    public void delete(ApiVersion object) throws Exception {
        super.delete(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object/component")
    public void update(ApiVersion object) throws Exception {
        super.update(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object/component")
    public void patch(ApiVersion object) throws Exception {
        super.patch(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.READ}, clazz=Component.class, target="output/component")
    public Optional<ApiVersion> findById(String id) throws Exception {
        return super.findById(id);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Component.class, target="output/component")
    public List<ApiVersion> findAll() throws Exception {
        return this.serviceDao.findAll(this.findAllIdsAuthorized());
    }

    public List<String> findAllIdsAuthorized() throws Exception {
        return ((ApiVersionDao)this.serviceDao).findAllByComponentIds(this.componentService.findAllIdsAuthorized());
    }
}

