/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.binaryrepository.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.BinaryRepository;
import org.kathra.resourcemanager.binaryrepository.dao.BinaryRepositoryDb;
import org.kathra.resourcemanager.binaryrepository.dao.BinaryRepositoryMapper;
import org.kathra.resourcemanager.binaryrepository.dao.BinaryRepositoryRepository;
import org.kathra.resourcemanager.group.dao.GroupBinaryRepositoryEdge;
import org.kathra.resourcemanager.group.dao.GroupBinaryRepositoryEdgeRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractBinaryRepositoryDao
extends AbstractResourceDao<BinaryRepository, BinaryRepositoryDb, String> {
    @Autowired
    GroupBinaryRepositoryEdgeRepository groupBinaryRepositoryEdgeRepository;
    BinaryRepositoryMapper mapper = (BinaryRepositoryMapper)Selma.mapper(BinaryRepositoryMapper.class);

    public AbstractBinaryRepositoryDao(@Autowired BinaryRepositoryRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new BinaryRepositoryDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.groupBinaryRepositoryEdgeRepository.count();
    }

    @Override
    public void create(BinaryRepository object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(BinaryRepository object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(BinaryRepository object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(BinaryRepository object) throws Exception {
        BinaryRepositoryDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(GroupBinaryRepositoryEdge.class).updateReference(resourceDb, "group", (CrudRepository<GroupBinaryRepositoryEdge, ?>)this.groupBinaryRepositoryEdgeRepository);
    }

    @Override
    public BinaryRepositoryDb convertResourceToResourceDb(BinaryRepository object) {
        return this.mapper.asBinaryRepositoryDb(object);
    }

    @Override
    public BinaryRepository convertResourceDbToResource(BinaryRepositoryDb object) {
        LeanResourceDbUtils<BinaryRepositoryDb> leanResourceDbUtils = new LeanResourceDbUtils<BinaryRepositoryDb>();
        return this.mapper.asBinaryRepository(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<BinaryRepository> convertResourceDbToResource(Stream<BinaryRepositoryDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asBinaryRepository((BinaryRepositoryDb)i));
    }
}

