/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.catalogentry.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.CatalogEntry;
import org.kathra.resourcemanager.catalogentry.dao.CatalogEntryDb;
import org.kathra.resourcemanager.catalogentry.dao.CatalogEntryMapper;
import org.kathra.resourcemanager.catalogentry.dao.CatalogEntryRepository;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageCatalogEntryEdge;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageCatalogEntryEdgeRepository;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageDb;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractCatalogEntryDao
extends AbstractResourceDao<CatalogEntry, CatalogEntryDb, String> {
    @Autowired
    CatalogEntryPackageCatalogEntryEdgeRepository catalogEntryPackageCatalogEntryEdgeRepository;
    CatalogEntryMapper mapper = (CatalogEntryMapper)Selma.mapper(CatalogEntryMapper.class);

    public AbstractCatalogEntryDao(@Autowired CatalogEntryRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new CatalogEntryDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.catalogEntryPackageCatalogEntryEdgeRepository.count();
    }

    @Override
    public void create(CatalogEntry object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(CatalogEntry object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(CatalogEntry object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(CatalogEntry object) throws Exception {
        CatalogEntryDb resourceDb = this.convertResourceToResourceDb(object);
        if (object.getPackages() != null) {
            List packagesItemsToUpdate = object.getPackages().parallelStream().filter(Objects::nonNull).map(i -> new CatalogEntryPackageDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(CatalogEntryPackageCatalogEntryEdge.class).updateList(resourceDb, packagesItemsToUpdate, (CrudRepository<CatalogEntryPackageCatalogEntryEdge, ?>)this.catalogEntryPackageCatalogEntryEdgeRepository);
        }
    }

    @Override
    public CatalogEntryDb convertResourceToResourceDb(CatalogEntry object) {
        return this.mapper.asCatalogEntryDb(object);
    }

    @Override
    public CatalogEntry convertResourceDbToResource(CatalogEntryDb object) {
        LeanResourceDbUtils<CatalogEntryDb> leanResourceDbUtils = new LeanResourceDbUtils<CatalogEntryDb>();
        return this.mapper.asCatalogEntry(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<CatalogEntry> convertResourceDbToResource(Stream<CatalogEntryDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asCatalogEntry((CatalogEntryDb)i));
    }
}

