/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.catalogentrypackage.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.CatalogEntryPackage;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageBinaryRepositoryEdge;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageBinaryRepositoryEdgeRepository;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageCatalogEntryEdge;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageCatalogEntryEdgeRepository;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageDb;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageMapper;
import org.kathra.resourcemanager.catalogentrypackage.dao.CatalogEntryPackageRepository;
import org.kathra.resourcemanager.pipeline.dao.PipelineCatalogEntryPackageEdge;
import org.kathra.resourcemanager.pipeline.dao.PipelineCatalogEntryPackageEdgeRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryCatalogEntryPackageEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryCatalogEntryPackageEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractCatalogEntryPackageDao
extends AbstractResourceDao<CatalogEntryPackage, CatalogEntryPackageDb, String> {
    @Autowired
    CatalogEntryPackageCatalogEntryEdgeRepository catalogEntryPackageCatalogEntryEdgeRepository;
    @Autowired
    CatalogEntryPackageBinaryRepositoryEdgeRepository catalogEntryPackageBinaryRepositoryEdgeRepository;
    @Autowired
    SourceRepositoryCatalogEntryPackageEdgeRepository sourceRepositoryCatalogEntryPackageEdgeRepository;
    @Autowired
    PipelineCatalogEntryPackageEdgeRepository pipelineCatalogEntryPackageEdgeRepository;
    CatalogEntryPackageMapper mapper = (CatalogEntryPackageMapper)Selma.mapper(CatalogEntryPackageMapper.class);

    public AbstractCatalogEntryPackageDao(@Autowired CatalogEntryPackageRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new CatalogEntryPackageDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.catalogEntryPackageCatalogEntryEdgeRepository.count();
        this.catalogEntryPackageBinaryRepositoryEdgeRepository.count();
        this.sourceRepositoryCatalogEntryPackageEdgeRepository.count();
        this.pipelineCatalogEntryPackageEdgeRepository.count();
    }

    @Override
    public void create(CatalogEntryPackage object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(CatalogEntryPackage object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(CatalogEntryPackage object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(CatalogEntryPackage object) throws Exception {
        CatalogEntryPackageDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(CatalogEntryPackageCatalogEntryEdge.class).updateReference(resourceDb, "catalogEntry", (CrudRepository<CatalogEntryPackageCatalogEntryEdge, ?>)this.catalogEntryPackageCatalogEntryEdgeRepository);
        EdgeUtils.of(CatalogEntryPackageBinaryRepositoryEdge.class).updateReference(resourceDb, "binaryRepository", (CrudRepository<CatalogEntryPackageBinaryRepositoryEdge, ?>)this.catalogEntryPackageBinaryRepositoryEdgeRepository);
        EdgeUtils.of(SourceRepositoryCatalogEntryPackageEdge.class).updateReference(resourceDb, "sourceRepository", (CrudRepository<SourceRepositoryCatalogEntryPackageEdge, ?>)this.sourceRepositoryCatalogEntryPackageEdgeRepository);
        EdgeUtils.of(PipelineCatalogEntryPackageEdge.class).updateReference(resourceDb, "pipeline", (CrudRepository<PipelineCatalogEntryPackageEdge, ?>)this.pipelineCatalogEntryPackageEdgeRepository);
    }

    @Override
    public CatalogEntryPackageDb convertResourceToResourceDb(CatalogEntryPackage object) {
        return this.mapper.asCatalogEntryPackageDb(object);
    }

    @Override
    public CatalogEntryPackage convertResourceDbToResource(CatalogEntryPackageDb object) {
        LeanResourceDbUtils<CatalogEntryPackageDb> leanResourceDbUtils = new LeanResourceDbUtils<CatalogEntryPackageDb>();
        return this.mapper.asCatalogEntryPackage(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<CatalogEntryPackage> convertResourceDbToResource(Stream<CatalogEntryPackageDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asCatalogEntryPackage((CatalogEntryPackageDb)i));
    }
}

