/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.component.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.Component;
import org.kathra.resourcemanager.apiversion.dao.ApiVersionDb;
import org.kathra.resourcemanager.component.dao.ComponentApiVersionEdge;
import org.kathra.resourcemanager.component.dao.ComponentApiVersionEdgeRepository;
import org.kathra.resourcemanager.component.dao.ComponentDb;
import org.kathra.resourcemanager.component.dao.ComponentMapper;
import org.kathra.resourcemanager.component.dao.ComponentRepository;
import org.kathra.resourcemanager.implementation.dao.ImplementationComponentEdge;
import org.kathra.resourcemanager.implementation.dao.ImplementationComponentEdgeRepository;
import org.kathra.resourcemanager.implementation.dao.ImplementationDb;
import org.kathra.resourcemanager.library.dao.LibraryComponentEdge;
import org.kathra.resourcemanager.library.dao.LibraryComponentEdgeRepository;
import org.kathra.resourcemanager.library.dao.LibraryDb;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryComponentEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryComponentEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractComponentDao
extends AbstractResourceDao<Component, ComponentDb, String> {
    @Autowired
    ComponentApiVersionEdgeRepository componentApiVersionEdgeRepository;
    @Autowired
    LibraryComponentEdgeRepository libraryComponentEdgeRepository;
    @Autowired
    ImplementationComponentEdgeRepository implementationComponentEdgeRepository;
    @Autowired
    SourceRepositoryComponentEdgeRepository sourceRepositoryComponentEdgeRepository;
    ComponentMapper mapper = (ComponentMapper)Selma.mapper(ComponentMapper.class);

    public AbstractComponentDao(@Autowired ComponentRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new ComponentDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.componentApiVersionEdgeRepository.count();
        this.libraryComponentEdgeRepository.count();
        this.implementationComponentEdgeRepository.count();
        this.sourceRepositoryComponentEdgeRepository.count();
    }

    @Override
    public void create(Component object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(Component object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(Component object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(Component object) throws Exception {
        ComponentDb resourceDb = this.convertResourceToResourceDb(object);
        if (object.getVersions() != null) {
            List versionsItemsToUpdate = object.getVersions().parallelStream().filter(Objects::nonNull).map(i -> new ApiVersionDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(ComponentApiVersionEdge.class).updateList(resourceDb, versionsItemsToUpdate, (CrudRepository<ComponentApiVersionEdge, ?>)this.componentApiVersionEdgeRepository);
        }
        if (object.getLibraries() != null) {
            List librariesItemsToUpdate = object.getLibraries().parallelStream().filter(Objects::nonNull).map(i -> new LibraryDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(LibraryComponentEdge.class).updateList(resourceDb, librariesItemsToUpdate, (CrudRepository<LibraryComponentEdge, ?>)this.libraryComponentEdgeRepository);
        }
        if (object.getImplementations() != null) {
            List implementationsItemsToUpdate = object.getImplementations().parallelStream().filter(Objects::nonNull).map(i -> new ImplementationDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(ImplementationComponentEdge.class).updateList(resourceDb, implementationsItemsToUpdate, (CrudRepository<ImplementationComponentEdge, ?>)this.implementationComponentEdgeRepository);
        }
        EdgeUtils.of(SourceRepositoryComponentEdge.class).updateReference(resourceDb, "apiRepository", (CrudRepository<SourceRepositoryComponentEdge, ?>)this.sourceRepositoryComponentEdgeRepository);
    }

    @Override
    public ComponentDb convertResourceToResourceDb(Component object) {
        return this.mapper.asComponentDb(object);
    }

    @Override
    public Component convertResourceDbToResource(ComponentDb object) {
        LeanResourceDbUtils<ComponentDb> leanResourceDbUtils = new LeanResourceDbUtils<ComponentDb>();
        return this.mapper.asComponent(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<Component> convertResourceDbToResource(Stream<ComponentDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asComponent((ComponentDb)i));
    }
}

