/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.component.service;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kathra.core.model.Component;
import org.kathra.resourcemanager.component.dao.ComponentDao;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.resourcemanager.resource.service.security.ResourceSecured;
import org.kathra.resourcemanager.resource.service.security.ResourceSecuredAction;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComponentService
extends AbstractService<Component, String> {
    @Autowired
    private ComponentService self = this;
    public final String METADATA_GROUP_IDENTIFIER = "groupId";
    public final String METADATA_GROUP_PATH = "groupPath";

    public ComponentService(@Autowired ComponentDao dao, @Autowired SessionService sessionService) {
        super(dao, sessionService);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.REGISTER, clazz=Component.class, target="object")
    public void create(Component object) throws Exception {
        if (StringUtils.isEmpty((CharSequence)object.getName())) {
            throw new IllegalArgumentException("Component's name should be defined");
        }
        if (object.getMetadata() == null || !object.getMetadata().containsKey("groupPath")) {
            throw new IllegalArgumentException("Metadata 'groupPath' should be defined");
        }
        if (object.getMetadata() == null || !object.getMetadata().containsKey("groupId")) {
            throw new IllegalArgumentException("Metadata 'groupId' should be defined");
        }
        super.create(object);
    }

    @ResourceSecured(action=ResourceSecuredAction.REGISTER, clazz=Component.class, target="object")
    public void create(Component object, String groupPath) throws Exception {
        object.putMetadataItem("groupPath", (Object)groupPath);
        this.create(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.UNREGISTER, clazz=Component.class, target="object")
    public void delete(Component object) throws Exception {
        super.delete(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object")
    public void update(Component object) throws Exception {
        super.update(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.UPDATE}, clazz=Component.class, target="object")
    public void patch(Component object) throws Exception {
        super.patch(object);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Component.class, target="output")
    public List<Component> findAll() throws Exception {
        List<String> ids = this.self.findAllIdsAuthorized();
        return this.serviceDao.findAll(ids);
    }

    @Override
    @ResourceSecured(action=ResourceSecuredAction.VALID, scopes={Scope.READ}, clazz=Component.class, target="id")
    public Optional<Component> findById(String id) throws Exception {
        return super.findById(id);
    }

    @ResourceSecured(action=ResourceSecuredAction.FILTER, scopes={Scope.READ}, clazz=Component.class, target="output")
    public List<String> findAllIdsAuthorized() throws Exception {
        return this.serviceDao.findAllIdentifiers();
    }
}

