/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.controller;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.CollectionType;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.module.jdk8.VPackJdk8Module;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.kathra.core.model.Resource;

public class ArangoDbController {
    ArangoDB arangoDb;
    ArangoDatabase database;
    private final ObjectMapper oMapper;

    public ArangoDbController(String host, int port, String user, String password, String dbname) {
        this.arangoDb = new ArangoDB.Builder().host(host, port).user(user).password(password).registerModule((VPackModule)new VPackJdk8Module()).build();
        this.database = this.arangoDb.db(dbname);
        this.oMapper = new ObjectMapper();
        this.oMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.oMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (!this.database.exists()) {
            this.arangoDb.createDatabase(dbname);
        }
    }

    public void initializeEdgesCollection(String name, String ... attributes) throws ArangoDBException {
        if (attributes != null && attributes.length > 0) {
            this.initializeEdgesCollection(name, new HashSet<String>(Arrays.asList(attributes)));
        }
    }

    public void initializeEdgesCollection(String name, Set<String> attributes) throws ArangoDBException {
        ArangoCollection collection = this.database.collection(name);
        if (!collection.exists()) {
            HashIndexOptions hio = new HashIndexOptions();
            hio.unique(Boolean.valueOf(true));
            this.database.createCollection(name, new CollectionCreateOptions().type(CollectionType.EDGES));
            collection.ensureHashIndex(attributes, hio);
        }
    }

    public void initializeCollection(String name) throws ArangoDBException {
        HashSet<String> attributes = new HashSet<String>();
        attributes.add("id");
        this.initializeCollection(name, attributes);
    }

    public void initializeCollection(String name, Set<String> attributes) throws ArangoDBException {
        ArangoCollection collection = this.database.collection(name);
        if (!collection.exists()) {
            this.database.createCollection(name, null);
            HashIndexOptions hio = new HashIndexOptions();
            hio.unique(Boolean.valueOf(true));
            collection.ensureHashIndex(attributes, hio);
            collection.ensureFulltextIndex(Collections.singletonList("name"), null);
        }
    }

    public void initializeCollection(String name, String ... attributes) throws ArangoDBException {
        if (attributes.length > 0) {
            this.initializeCollection(name, new HashSet<String>(Arrays.asList(attributes)));
        }
    }

    public ArangoDatabase getDatabase() {
        return this.database;
    }

    public BaseDocument createResource(Resource body) throws ArangoDBException {
        return this.createResource(body, body.getClass().getSimpleName().toLowerCase() + "s");
    }

    public BaseDocument createResource(Resource body, String collection) throws ArangoDBException {
        if (body.getId() == null || body.getId().isEmpty()) {
            body.id(this.generateGUID());
        }
        ObjectMapper oMapper = new ObjectMapper();
        Map map = (Map)oMapper.convertValue((Object)body, Map.class);
        BaseDocument myObject = new BaseDocument(map);
        myObject.setKey(body.getId());
        myObject.setId(body.getId());
        this.database.collection(collection).insertDocument((Object)myObject);
        return myObject;
    }

    public boolean deleteResource(String id, Class c) {
        HashMap<String, String> bindVars = new HashMap<String, String>();
        bindVars.put("id", id);
        bindVars.put("@collection", c.getSimpleName().toLowerCase());
        String aqlQuery = "FOR resource IN @@collection FILTER resource.id == @id REMOVE resource IN @@collection";
        this.database.query(aqlQuery, bindVars, null, c);
        return true;
    }

    public Object getResource(String id, String collection) throws Exception {
        return this.getResource(id, Object.class, collection);
    }

    public Object getResource(String id, Class c) throws Exception {
        return this.getResource(id, c, c.getSimpleName().toLowerCase());
    }

    public Object getResource(String id, Class c, String collection) throws Exception {
        HashMap<String, String> bindVars = new HashMap<String, String>();
        bindVars.put("id", id);
        bindVars.put("@collection", collection);
        String aqlQuery = "FOR resource IN @@collection FILTER resource.id == @id RETURN resource";
        ArangoCursor cursor = this.database.query(aqlQuery, bindVars, null, c);
        Object o = null;
        while (cursor.hasNext()) {
            o = cursor.next();
        }
        cursor.close();
        return o;
    }

    public <O, C extends Class> List<O> getResourcesById(List<String> ids, C c, String collection) throws Exception {
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        bindVars.put("ids", ids);
        bindVars.put("@collection", collection);
        String aqlQuery = "FOR resource IN @@collection FILTER resource.id IN @ids SORT resource.id ASC RETURN resource";
        ArangoCursor cursor = this.database.query(aqlQuery, bindVars, null, Object.class);
        ArrayList<Object> o = new ArrayList<Object>();
        while (cursor.hasNext()) {
            o.add(this.oMapper.convertValue(cursor.next(), c));
        }
        cursor.close();
        return o;
    }

    public <O, C extends Class> List<O> getResourcesById(List<String> ids, C c) throws Exception {
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        bindVars.put("ids", ids);
        bindVars.put("@collection", c.getSimpleName().toLowerCase());
        String aqlQuery = "FOR resource IN @@collection FILTER resource.id IN @ids SORT resource.id ASC RETURN resource";
        ArangoCursor cursor = this.database.query(aqlQuery, bindVars, null, c);
        ArrayList o = new ArrayList();
        while (cursor.hasNext()) {
            o.add(c.cast(cursor.next()));
        }
        cursor.close();
        return o;
    }

    public <O, C extends Class> List<O> getAllResources(String query, C c) throws Exception {
        String aqlQuery;
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        bindVars.put("@collection", c.getSimpleName().toLowerCase() + "s");
        if (query != null && !query.isEmpty()) {
            bindVars.put("name", query);
            aqlQuery = "FOR resources IN FULLTEXT(\"@@collection\", \"name\", @name) RETURN resources";
        } else {
            aqlQuery = "FOR resources IN @@collection LIMIT 1000 RETURN resources";
        }
        ArangoCursor cursor = this.database.query(aqlQuery, bindVars, null, c);
        ArrayList l = new ArrayList();
        while (cursor.hasNext()) {
            l.add(c.cast(cursor.next()));
        }
        cursor.close();
        return l;
    }

    public <O, C extends Class> List<O> getAllResources(C c, List<String> fields) throws Exception {
        if (fields == null || fields.size() == 0) {
            return this.getAllResources(null, c);
        }
        HashMap<String, String> bindVars = new HashMap<String, String>();
        bindVars.put("@collection", c.getSimpleName().toLowerCase());
        Object aqlQuery = "FOR resource IN @@collection RETURN { ";
        int fieldsNumber = fields.size();
        int fieldCounter = 0;
        for (String field : fields) {
            aqlQuery = (String)aqlQuery + field + ": resource." + field;
            if (++fieldCounter >= fieldsNumber) continue;
            aqlQuery = (String)aqlQuery + ", ";
        }
        aqlQuery = (String)aqlQuery + " }";
        System.out.println("=> " + (String)aqlQuery);
        ArangoCursor cursor = this.database.query((String)aqlQuery, bindVars, null, c);
        ArrayList result = new ArrayList();
        while (cursor.hasNext()) {
            result.add(c.cast(cursor.next()));
        }
        cursor.close();
        return result;
    }

    public boolean updateResource(String id, Object body) {
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        bindVars.put("body", body);
        bindVars.put("id", id);
        bindVars.put("@collection", body.getClass().getSimpleName().toLowerCase());
        String aqlQuery = "FOR resource IN @@collection FILTER resource.id == @id REPLACE resource WITH @body IN @@collection";
        this.database.query(aqlQuery, bindVars, null, body.getClass());
        return true;
    }

    public <O> Object updateResourceAttributes(String id, O o, String collection) {
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        bindVars.put("body", o);
        bindVars.put("id", collection + "/" + id);
        DocumentUpdateOptions options = new DocumentUpdateOptions();
        options.returnNew(Boolean.valueOf(true));
        HashMap aNew = (HashMap)this.database.collection(collection).updateDocument(id, (Object)((HashMap)this.oMapper.convertValue(o, HashMap.class)), options).getNew();
        return this.oMapper.convertValue((Object)aNew, o.getClass());
    }

    private String getNewIdForResource(String collection) throws IOException {
        HashMap<String, String> bindVars = new HashMap<String, String>();
        bindVars.put("@collection", collection);
        String aqlQuery = "FOR resource IN @@collection COLLECT AGGREGATE maxId = MAX(resource.id) RETURN maxId";
        ArangoCursor cursor = this.database.query(aqlQuery, bindVars, null, String.class);
        String l = null;
        if (cursor.hasNext()) {
            l = (String)cursor.next();
        }
        cursor.close();
        return l == null ? Integer.toUnsignedString(1) : l + "1";
    }

    private String generateGUID() {
        return UUID.randomUUID().toString();
    }
}

