/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.group.service;

import java.util.List;
import java.util.Optional;
import org.kathra.core.model.Group;
import org.kathra.resourcemanager.group.dao.GroupDao;
import org.kathra.resourcemanager.resource.service.AbstractService;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupService
extends AbstractService<Group, String> {
    public GroupService(@Autowired GroupDao dao, @Autowired SessionService sessionService) {
        super(dao, sessionService);
    }

    @Override
    public void create(Group object) throws Exception {
        this.checkGroupPathUnicity(object);
        super.create(object);
    }

    @Override
    public void delete(Group object) throws Exception {
        super.delete(object);
    }

    @Override
    public void update(Group object) throws Exception {
        this.checkGroupPathUnicity(object);
        super.update(object);
    }

    @Override
    public void patch(Group object) throws Exception {
        if (object.getPath() != null) {
            this.checkGroupPathUnicity(object);
        }
        super.patch(object);
    }

    @Override
    public List<Group> findAll() throws Exception {
        return super.findAll();
    }

    private void checkGroupPathUnicity(Group object) throws Exception {
        if (object.getPath() == null) {
            throw new IllegalArgumentException("Group's path is null");
        }
        Optional<Group> groupWithSamePath = this.findByPath(object.getPath());
        if (this.findByPath(object.getPath()).isPresent() && (!groupWithSamePath.get().getId().equals(object.getId()) || object.getId() == null)) {
            throw new IllegalArgumentException("Group's path already exists");
        }
    }

    public Optional<Group> findByPath(String path) throws Exception {
        return super.findAll().parallelStream().filter(group -> group.getPath().equals(path)).findFirst();
    }

    @Override
    public Optional<Group> findById(String id) throws Exception {
        return super.findById(id);
    }
}

