/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.library.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.Library;
import org.kathra.resourcemanager.library.dao.LibraryBinaryRepositoryEdge;
import org.kathra.resourcemanager.library.dao.LibraryBinaryRepositoryEdgeRepository;
import org.kathra.resourcemanager.library.dao.LibraryComponentEdge;
import org.kathra.resourcemanager.library.dao.LibraryComponentEdgeRepository;
import org.kathra.resourcemanager.library.dao.LibraryDb;
import org.kathra.resourcemanager.library.dao.LibraryMapper;
import org.kathra.resourcemanager.library.dao.LibraryRepository;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionDb;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionLibraryEdge;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionLibraryEdgeRepository;
import org.kathra.resourcemanager.pipeline.dao.PipelineLibraryEdge;
import org.kathra.resourcemanager.pipeline.dao.PipelineLibraryEdgeRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryLibraryEdge;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryLibraryEdgeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractLibraryDao
extends AbstractResourceDao<Library, LibraryDb, String> {
    @Autowired
    LibraryComponentEdgeRepository libraryComponentEdgeRepository;
    @Autowired
    LibraryApiVersionLibraryEdgeRepository libraryApiVersionLibraryEdgeRepository;
    @Autowired
    LibraryBinaryRepositoryEdgeRepository libraryBinaryRepositoryEdgeRepository;
    @Autowired
    SourceRepositoryLibraryEdgeRepository sourceRepositoryLibraryEdgeRepository;
    @Autowired
    PipelineLibraryEdgeRepository pipelineLibraryEdgeRepository;
    LibraryMapper mapper = (LibraryMapper)Selma.mapper(LibraryMapper.class);

    public AbstractLibraryDao(@Autowired LibraryRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new LibraryDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.libraryComponentEdgeRepository.count();
        this.libraryApiVersionLibraryEdgeRepository.count();
        this.libraryBinaryRepositoryEdgeRepository.count();
        this.sourceRepositoryLibraryEdgeRepository.count();
        this.pipelineLibraryEdgeRepository.count();
    }

    @Override
    public void create(Library object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(Library object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(Library object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(Library object) throws Exception {
        LibraryDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(LibraryComponentEdge.class).updateReference(resourceDb, "component", (CrudRepository<LibraryComponentEdge, ?>)this.libraryComponentEdgeRepository);
        if (object.getVersions() != null) {
            List versionsItemsToUpdate = object.getVersions().parallelStream().filter(Objects::nonNull).map(i -> new LibraryApiVersionDb(i.getId())).collect(Collectors.toList());
            EdgeUtils.of(LibraryApiVersionLibraryEdge.class).updateList(resourceDb, versionsItemsToUpdate, (CrudRepository<LibraryApiVersionLibraryEdge, ?>)this.libraryApiVersionLibraryEdgeRepository);
        }
        EdgeUtils.of(LibraryBinaryRepositoryEdge.class).updateReference(resourceDb, "binaryRepository", (CrudRepository<LibraryBinaryRepositoryEdge, ?>)this.libraryBinaryRepositoryEdgeRepository);
        EdgeUtils.of(SourceRepositoryLibraryEdge.class).updateReference(resourceDb, "sourceRepository", (CrudRepository<SourceRepositoryLibraryEdge, ?>)this.sourceRepositoryLibraryEdgeRepository);
        EdgeUtils.of(PipelineLibraryEdge.class).updateReference(resourceDb, "pipeline", (CrudRepository<PipelineLibraryEdge, ?>)this.pipelineLibraryEdgeRepository);
    }

    @Override
    public LibraryDb convertResourceToResourceDb(Library object) {
        return this.mapper.asLibraryDb(object);
    }

    @Override
    public Library convertResourceDbToResource(LibraryDb object) {
        LeanResourceDbUtils<LibraryDb> leanResourceDbUtils = new LeanResourceDbUtils<LibraryDb>();
        return this.mapper.asLibrary(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<Library> convertResourceDbToResource(Stream<LibraryDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asLibrary((LibraryDb)i));
    }
}

