/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.libraryapiversion.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.LibraryApiVersion;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionApiVersionEdge;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionApiVersionEdgeRepository;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionDb;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionLibraryEdge;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionLibraryEdgeRepository;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionMapper;
import org.kathra.resourcemanager.libraryapiversion.dao.LibraryApiVersionRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.EdgeUtils;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractLibraryApiVersionDao
extends AbstractResourceDao<LibraryApiVersion, LibraryApiVersionDb, String> {
    @Autowired
    LibraryApiVersionLibraryEdgeRepository libraryApiVersionLibraryEdgeRepository;
    @Autowired
    LibraryApiVersionApiVersionEdgeRepository libraryApiVersionApiVersionEdgeRepository;
    LibraryApiVersionMapper mapper = (LibraryApiVersionMapper)Selma.mapper(LibraryApiVersionMapper.class);

    public AbstractLibraryApiVersionDao(@Autowired LibraryApiVersionRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new LibraryApiVersionDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.libraryApiVersionLibraryEdgeRepository.count();
        this.libraryApiVersionApiVersionEdgeRepository.count();
    }

    @Override
    public void create(LibraryApiVersion object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(LibraryApiVersion object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(LibraryApiVersion object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(LibraryApiVersion object) throws Exception {
        LibraryApiVersionDb resourceDb = this.convertResourceToResourceDb(object);
        EdgeUtils.of(LibraryApiVersionLibraryEdge.class).updateReference(resourceDb, "library", (CrudRepository<LibraryApiVersionLibraryEdge, ?>)this.libraryApiVersionLibraryEdgeRepository);
        EdgeUtils.of(LibraryApiVersionApiVersionEdge.class).updateReference(resourceDb, "apiVersion", (CrudRepository<LibraryApiVersionApiVersionEdge, ?>)this.libraryApiVersionApiVersionEdgeRepository);
    }

    @Override
    public LibraryApiVersionDb convertResourceToResourceDb(LibraryApiVersion object) {
        return this.mapper.asLibraryApiVersionDb(object);
    }

    @Override
    public LibraryApiVersion convertResourceDbToResource(LibraryApiVersionDb object) {
        LeanResourceDbUtils<LibraryApiVersionDb> leanResourceDbUtils = new LeanResourceDbUtils<LibraryApiVersionDb>();
        return this.mapper.asLibraryApiVersion(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<LibraryApiVersion> convertResourceDbToResource(Stream<LibraryApiVersionDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asLibraryApiVersion((LibraryApiVersionDb)i));
    }
}

