/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.dao.IResourceDb;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;

public interface ConverterResourceToResourceDb<X extends Resource, V extends IResourceDb> {
    default public V convertResourceToResourceDb(X object) {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        return (V)((IResourceDb)modelMapper.map(object, ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1]));
    }

    default public X convertResourceDbToResource(V object) {
        LeanResourceDbUtils<V> leanResourceDbUtils = new LeanResourceDbUtils<V>();
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        return (X)((Resource)modelMapper.map(leanResourceDbUtils.leanResourceDb(object), ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]));
    }

    default public List<X> convertResourceDbToResource(List<V> objects) {
        return this.convertResourceDbToResource(objects.stream()).collect(Collectors.toList());
    }

    default public Stream<X> convertResourceDbToResource(Stream<V> objectsStream) {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        List lean = objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList());
        return lean.parallelStream().map(i -> (Resource)modelMapper.map(i, type));
    }
}

