/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.service;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.LeanResourceUtils;
import org.kathra.resourcemanager.security.SessionService;

public abstract class AbstractService<X extends Resource, ID> {
    protected AbstractResourceDao<X, ?, ID> serviceDao;
    protected SessionService sessionService;
    private LeanResourceUtils<X> leanUtils = new LeanResourceUtils();

    public AbstractService(AbstractResourceDao serviceDao, SessionService sessionService) {
        this.serviceDao = serviceDao;
        this.sessionService = sessionService;
    }

    protected String getAuthor() {
        if (this.sessionService.getCurrentSession() == null) {
            throw new IllegalStateException("Unable to find current session");
        }
        if (this.sessionService.getCurrentSession().getCallerName() == null) {
            throw new IllegalStateException("Unable to find caller name from current session");
        }
        return this.sessionService.getCurrentSession().getCallerName();
    }

    public void create(X object) throws Exception {
        this.serviceDao.create(object, this.getAuthor());
    }

    public void delete(X object) throws Exception {
        this.serviceDao.delete(object, this.getAuthor());
    }

    public void update(X object) throws Exception {
        this.serviceDao.update(object, this.getAuthor());
    }

    public void patch(X object) throws Exception {
        Optional<X> objectToUpdate = this.serviceDao.findById(object.getId());
        if (!objectToUpdate.isPresent()) {
            throw new NotFoundException("Unable to find " + object.getId());
        }
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                this.patchProperty(object, (Resource)objectToUpdate.get(), propertyDescriptor);
            }
            this.serviceDao.update((Resource)objectToUpdate.get(), this.getAuthor());
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void patchProperty(X objectPatched, X objectToUpdate, PropertyDescriptor propertyDescriptor) throws Exception {
        Object valueDefined;
        if (propertyDescriptor.getName().equals("metadata") && objectPatched.getMetadata() != null) {
            if (objectToUpdate.getMetadata() == null) {
                objectToUpdate.setMetadata(objectPatched.getMetadata());
            } else {
                objectToUpdate.getMetadata().putAll(objectPatched.getMetadata());
            }
        } else if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && (valueDefined = propertyDescriptor.getReadMethod().invoke(objectPatched, new Object[0])) != null) {
            propertyDescriptor.getWriteMethod().invoke(objectToUpdate, valueDefined);
        }
    }

    public List<X> findAll() throws Exception {
        return this.serviceDao.findAll().parallelStream().map(this.leanUtils::leanObject).collect(Collectors.toList());
    }

    public Optional<X> findById(ID id) throws Exception {
        return this.serviceDao.findById(id).map(this.leanUtils::leanObject);
    }
}

