/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.service.security;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.service.security.ResourceSecured;
import org.kathra.resourcemanager.resource.service.security.ResourceSecurityService;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SecurityContext;
import org.kathra.resourcemanager.security.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResourceSecurityProcessor {
    @Autowired
    private ResourceSecurityService resourceSecurityService;
    @Autowired
    private SessionService sessionSecurity;
    private DefaultParameterNameDiscoverer defaultParameterNameDiscoverer;
    private static final String TARGET_OUTPUT_PREFIX = "output";
    private static final String TARGET_SEPARATOR_JXPATH = "/";

    public ResourceSecurityProcessor() {
        this.defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    }

    public ResourceSecurityProcessor(ResourceSecurityService resourceSecurityService, SessionService sessionSecurity) {
        this.resourceSecurityService = resourceSecurityService;
        this.sessionSecurity = sessionSecurity;
        this.defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    }

    public ResourceSecurityProcessor(ResourceSecurityService resourceSecurityService, SessionService sessionSecurity, DefaultParameterNameDiscoverer defaultParameterNameDiscoverer) {
        this.resourceSecurityService = resourceSecurityService;
        this.sessionSecurity = sessionSecurity;
        this.defaultParameterNameDiscoverer = defaultParameterNameDiscoverer;
    }

    @Before(value="@annotation(ResourceSecured)")
    public void before(JoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        ResourceSecured resourceSecuredAnnotation = ((Executable)method).getAnnotation(ResourceSecured.class);
        switch (resourceSecuredAnnotation.action()) {
            case VALID: {
                Optional<Object> targetToValidate = this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation);
                String XPath = this.getJXPathFromTarget(resourceSecuredAnnotation);
                if (!targetToValidate.isPresent()) break;
                this.validate(resourceSecuredAnnotation, this.sessionSecurity.get(), XPath == null ? targetToValidate.get() : this.getObjectFromXPath(targetToValidate.get(), XPath));
                break;
            }
            case FILTER: {
                Optional<Object> targetToFilter = this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation);
                if (!targetToFilter.isPresent()) break;
                if (targetToFilter.get() instanceof List) {
                    this.filter(resourceSecuredAnnotation, this.sessionSecurity.get(), (List)targetToFilter.get());
                    break;
                }
                throw new IllegalStateException("Input param object to filter should be a list");
            }
        }
    }

    private Optional<Object> getTargetFromJoinPoint(JoinPoint joinPoint, ResourceSecured resourceSecuredAnnotation) {
        String[] params = this.defaultParameterNameDiscoverer.getParameterNames(((MethodSignature)joinPoint.getSignature()).getMethod());
        Optional<Object> object = IntStream.range(0, params.length).filter(i -> params[i].equals(this.getRootFromTarget(resourceSecuredAnnotation))).mapToObj(i -> joinPoint.getArgs()[i]).findFirst();
        return object;
    }

    private Object getTargetFromOutput(Object outputObject, ResourceSecured resourceSecuredAnnotation) {
        Object objectToGet;
        if (!resourceSecuredAnnotation.target().startsWith(TARGET_OUTPUT_PREFIX)) {
            throw new IllegalStateException("target should start with 'output'");
        }
        Object object = objectToGet = outputObject instanceof Optional ? ((Optional)outputObject).orElse(null) : outputObject;
        if (objectToGet == null) {
            return null;
        }
        String XPath = this.getJXPathFromTarget(resourceSecuredAnnotation);
        return XPath != null ? this.getObjectFromXPath(objectToGet, XPath) : objectToGet;
    }

    private Object getObjectFromXPath(Object object, String JXPath) {
        Object propertyObject = JXPathContext.newContext((Object)object).getValue(JXPath);
        if (propertyObject == null) {
            throw new IllegalArgumentException("Property from JXPath " + JXPath + " of " + object.getClass().toString() + "'s instance is null");
        }
        return propertyObject;
    }

    @AfterReturning(pointcut="@annotation(ResourceSecured)", returning="objectReturned")
    public void after(JoinPoint joinPoint, Object objectReturned) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        ResourceSecured resourceSecuredAnnotation = method.getAnnotation(ResourceSecured.class);
        SecurityContext context = this.sessionSecurity.get();
        switch (resourceSecuredAnnotation.action()) {
            case VALID: {
                if (!resourceSecuredAnnotation.target().startsWith(TARGET_OUTPUT_PREFIX) || this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation).isPresent()) break;
                this.validate(resourceSecuredAnnotation, context, this.getTargetFromOutput(objectReturned, resourceSecuredAnnotation));
                break;
            }
            case FILTER: {
                if (!resourceSecuredAnnotation.target().startsWith(TARGET_OUTPUT_PREFIX) || this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation).isPresent()) break;
                if (objectReturned instanceof List) {
                    this.filter(resourceSecuredAnnotation, this.sessionSecurity.get(), (List)objectReturned);
                    break;
                }
                throw new IllegalStateException("Input param object to filter should be a list");
            }
            case REGISTER: {
                Optional<Object> targetToRegister = this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation);
                if (!targetToRegister.isPresent() && resourceSecuredAnnotation.target().startsWith(TARGET_OUTPUT_PREFIX)) {
                    targetToRegister = Optional.of(objectReturned);
                }
                if (!targetToRegister.isPresent() || !targetToRegister.get().getClass().isAssignableFrom(resourceSecuredAnnotation.clazz())) break;
                this.resourceSecurityService.grantAccess(context, (Resource)targetToRegister.get(), resourceSecuredAnnotation.scopes());
                break;
            }
            case UNREGISTER: {
                Optional<Object> targetToUnregister = this.getTargetFromJoinPoint(joinPoint, resourceSecuredAnnotation);
                if (!targetToUnregister.isPresent() && resourceSecuredAnnotation.target().startsWith(TARGET_OUTPUT_PREFIX)) {
                    targetToUnregister = Optional.of(objectReturned);
                }
                if (!targetToUnregister.isPresent() || !targetToUnregister.get().getClass().isAssignableFrom(resourceSecuredAnnotation.clazz())) break;
                this.resourceSecurityService.revokeAccess(context, (Resource)targetToUnregister.get());
            }
        }
    }

    private void validate(ResourceSecured resourceSecuredAnnotation, SecurityContext context, Object argument) throws Exception {
        if (argument instanceof Resource && argument.getClass().isAssignableFrom(resourceSecuredAnnotation.clazz())) {
            this.checkResource(resourceSecuredAnnotation, context, (Resource)argument);
        } else if (argument instanceof List) {
            List list = (List)argument;
            List<String> ids = this.getIdentifiersAuthorized(context, resourceSecuredAnnotation.scopes(), resourceSecuredAnnotation.clazz());
            for (Object item : list) {
                if (!(item instanceof Resource) || !item.getClass().isAssignableFrom(resourceSecuredAnnotation.clazz()) || ids.contains(((Resource)item).getId())) continue;
                throw new IllegalAccessException("Access denied for resource " + ((Resource)item).getId());
            }
        } else if (argument instanceof String) {
            Resource resource = resourceSecuredAnnotation.clazz().getConstructor(new Class[0]).newInstance(new Object[0]);
            resource.setId((String)argument);
            this.checkResource(resourceSecuredAnnotation, context, resource);
        } else if (argument != null) {
            throw new NotImplementedException("Not implemented ! ");
        }
    }

    private String getRootFromTarget(ResourceSecured resourceSecuredAnnotation) {
        return resourceSecuredAnnotation.target().split(TARGET_SEPARATOR_JXPATH)[0];
    }

    private String getJXPathFromTarget(ResourceSecured resourceSecuredAnnotation) {
        String target = resourceSecuredAnnotation.target();
        Object[] objectPath = target.split(TARGET_SEPARATOR_JXPATH);
        if (objectPath.length > 1) {
            return String.join((CharSequence)".", (CharSequence[])ArrayUtils.remove((Object[])objectPath, (int)0));
        }
        return null;
    }

    private void filter(ResourceSecured resourceSecuredAnnotation, SecurityContext context, List list) throws Exception {
        ArrayList itemsToRemove = new ArrayList();
        String XPath = this.getJXPathFromTarget(resourceSecuredAnnotation);
        HashMap<Class<? extends Resource>, List<String>> idsAuthorized = new HashMap<Class<? extends Resource>, List<String>>();
        for (Object item : list) {
            Resource resourceToValidate;
            Object objectToValidate;
            Object object = objectToValidate = XPath == null ? item : this.getObjectFromXPath(item, XPath);
            if (objectToValidate instanceof String) {
                resourceToValidate = resourceSecuredAnnotation.clazz().getConstructor(new Class[0]).newInstance(new Object[0]);
                resourceToValidate.setId((String)objectToValidate);
            } else {
                if (!(objectToValidate instanceof Resource)) continue;
                resourceToValidate = (Resource)objectToValidate;
            }
            Class<? extends Resource> clazz = resourceSecuredAnnotation.clazz();
            if (!idsAuthorized.containsKey(clazz)) {
                idsAuthorized.put(clazz, this.getIdentifiersAuthorized(context, resourceSecuredAnnotation.scopes(), clazz));
            }
            if (((List)idsAuthorized.get(clazz)).contains(resourceToValidate.getId())) continue;
            itemsToRemove.add(item);
        }
        list.removeAll(itemsToRemove);
    }

    private List<String> getIdentifiersAuthorized(SecurityContext securityContext, Scope[] scopes, Class clazz) throws Exception {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Scope scope : scopes) {
            List<String> idAuthorizedForScope = this.resourceSecurityService.getIdsAuthorized(securityContext, clazz, scope);
            if (identifiers.isEmpty()) {
                identifiers.addAll(idAuthorizedForScope);
                continue;
            }
            List idsNotAuthorized = identifiers.parallelStream().filter(id -> idAuthorizedForScope.stream().noneMatch(idScope -> idScope.equals(id))).collect(Collectors.toList());
            identifiers.removeAll(idsNotAuthorized);
        }
        return identifiers;
    }

    private void checkResource(ResourceSecured resourceSecuredAnnotation, SecurityContext context, Resource argument) throws Exception {
        for (Scope scope : resourceSecuredAnnotation.scopes()) {
            if (this.resourceSecurityService.isAuthorized(context, argument, scope)) continue;
            throw new IllegalAccessException("Access denied (scope:" + scope + ") for resource " + argument.getId());
        }
    }
}

