/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.service.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.service.security.KeycloakClient;
import org.kathra.resourcemanager.resource.service.security.Scope;
import org.kathra.resourcemanager.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceSecurityService {
    Logger logger = LoggerFactory.getLogger(ResourceSecurityService.class);
    @Autowired
    KeycloakClient keycloakClient;

    public List<String> getIdsAuthorized(SecurityContext context, Class<? extends Resource> clazz, Scope scope) throws Exception {
        try {
            return this.keycloakClient.getResourcesByType(context.getSession(), this.getTypeFromClazz(clazz), this.getScopeIdentifier(clazz, scope));
        }
        catch (Exception e) {
            this.logger.error("unable to get identifiers authorized for resources " + this.getTypeFromClazz(clazz) + " with scope " + scope.getScopeName());
            throw e;
        }
    }

    public boolean isAuthorized(SecurityContext context, Resource resource, Scope scope) throws Exception {
        try {
            String result = this.keycloakClient.getResourceById(context.getSession(), this.getIdentifier(resource), this.getScopeIdentifier(resource.getClass(), scope));
            return result != null && result.equals(this.getIdentifier(resource));
        }
        catch (Exception e) {
            this.logger.error("unable to get identifiers authorized for resources " + this.getIdentifier(resource) + " with scope " + scope.getScopeName());
            throw e;
        }
    }

    private String getTypeFromClazz(Class clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public String getScopeIdentifier(Class clazz, Scope scope) {
        return "kathra:scope:" + this.getTypeFromClazz(clazz) + ":" + scope.getScopeName();
    }

    public void grantAccess(SecurityContext context, Resource resource, Scope[] scopes) throws Exception {
        List<String> scopesString = Arrays.stream(scopes).map(scope -> this.getScopeIdentifier(resource.getClass(), (Scope)((Object)scope))).collect(Collectors.toList());
        try {
            this.keycloakClient.createResource(context.getSession(), this.getTypeFromClazz(resource.getClass()), resource.getId(), scopesString, this.getMetadata(resource));
        }
        catch (Exception e) {
            this.logger.error("unable to grant access to resource " + this.getIdentifier(resource) + " with scopes : " + String.join((CharSequence)",", scopesString));
            throw e;
        }
    }

    private Map<String, String> getMetadata(Resource resource) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (resource.getMetadata() != null) {
            for (Map.Entry entry : resource.getMetadata().entrySet()) {
                metadata.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return metadata;
    }

    public void revokeAccess(SecurityContext context, Resource resource) throws Exception {
        AtomicReference<Exception> exception = new AtomicReference<Exception>();
        try {
            this.keycloakClient.deleteResource(context.getSession(), this.getIdentifier(resource), this.getScopeIdentifier(resource.getClass(), Scope.DELETE));
        }
        catch (Exception e) {
            this.logger.error("unable to revoke access to resource " + this.getIdentifier(resource) + " with scope " + Scope.DELETE);
            exception.set(e);
        }
    }

    public void deleteResourceScope(SecurityContext context, Resource resource, Scope[] scopes) throws Exception {
        AtomicReference exception = new AtomicReference();
        Arrays.stream(scopes).forEach(scope -> {
            try {
                this.keycloakClient.deleteResourceScope(context.getSession(), this.getIdentifier(resource), this.getScopeIdentifier(resource.getClass(), (Scope)((Object)scope)));
            }
            catch (Exception e) {
                this.logger.error("unable to delete scope to resource " + this.getIdentifier(resource) + " with scope " + scope.getScopeName());
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    private String getIdentifier(Resource resource) {
        return resource.getId();
    }
}

