/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.resource.utils;

import com.arangodb.springframework.annotation.Edge;
import com.arangodb.springframework.annotation.From;
import com.arangodb.springframework.annotation.To;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.kathra.core.model.Resource;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDb;
import org.kathra.resourcemanager.resource.dao.IResourceDb;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.Repository;

public class EdgeUtils<X> {
    private static final String PREFIX_METHOD_REPOSITORY = "findAllBy";
    private static Logger logger = Logger.getLogger(EdgeUtils.class);
    private final Class<X> typeParameterClass;
    private final PropertyDescriptor[] propertiesDescriptors;

    public EdgeUtils(Class<X> edgeClass) {
        this.typeParameterClass = edgeClass;
        try {
            this.propertiesDescriptors = Introspector.getBeanInfo(this.typeParameterClass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to init edge utils for class " + this.typeParameterClass.getName());
        }
        this.checkClass(edgeClass);
    }

    private void checkClass(Class<X> edgeClass) {
        if (edgeClass.getAnnotation(Edge.class) == null) {
            throw new IllegalArgumentException("Class should annoted with " + Edge.class.getName() + ".");
        }
        try {
            this.getEdgeAttributeFromAnnotation(From.class);
            this.getEdgeAttributeFromAnnotation(To.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class should have attributes annoted with " + From.class.getName() + " and " + To.class.getName() + ".");
        }
    }

    public static <U> EdgeUtils<U> of(Class<U> edgeClass) {
        return new EdgeUtils<U>(edgeClass);
    }

    public void updateReference(AbstractResourceDb resourceDb, String propertyName, CrudRepository<X, ?> repository) throws Exception {
        try {
            boolean linkIsBroken;
            PropertyDescriptor property = Arrays.stream(Introspector.getBeanInfo(resourceDb.getClass()).getPropertyDescriptors()).filter(propertyDescriptor -> propertyDescriptor.getName().equals(propertyName)).findFirst().get();
            AbstractResourceDb linkedObject = (AbstractResourceDb)property.getReadMethod().invoke((Object)resourceDb, new Object[0]);
            Field attributeParent = null;
            Field attributeChild = null;
            if (resourceDb.getClass().equals(property.getPropertyType())) {
                attributeParent = this.getEdgeAttribute(resourceDb.getClass(), "parent");
                attributeChild = this.getEdgeAttribute(property.getPropertyType(), "child");
            } else {
                attributeParent = this.getEdgeAttribute(resourceDb.getClass());
                attributeChild = this.getEdgeAttribute(property.getPropertyType());
            }
            boolean bl = linkIsBroken = Resource.StatusEnum.DELETED.equals((Object)resourceDb.getStatus()) || linkedObject != null && Resource.StatusEnum.DELETED.equals((Object)linkedObject.getStatus());
            if (linkedObject != null && linkedObject.getId() != null && !linkIsBroken) {
                Method methodFindAllByResourceDb = repository.getClass().getMethod(PREFIX_METHOD_REPOSITORY + StringUtils.capitalize((String)attributeParent.getName()), String.class);
                List links = (List)methodFindAllByResourceDb.invoke(repository, resourceDb.toArangoIdentifier());
                boolean linkExist = false;
                if (!links.isEmpty()) {
                    PropertyDescriptor linkedObjectProperty = Arrays.stream(Introspector.getBeanInfo(links.get(0).getClass()).getPropertyDescriptors()).filter(propertyDescriptor -> propertyDescriptor.getPropertyType().equals(linkedObject.getClass())).findFirst().get();
                    for (Object link : links) {
                        if (!((AbstractResourceDb)linkedObjectProperty.getReadMethod().invoke(link, new Object[0])).getId().equals(linkedObject.getId())) {
                            repository.delete(link);
                            continue;
                        }
                        linkExist = true;
                    }
                }
                if (!linkExist) {
                    X edge = this.getNewInstanceOfEdge(resourceDb, attributeParent, attributeChild, linkedObject);
                    repository.save(edge);
                }
            } else {
                Method methodDeleteByResourceDb = repository.getClass().getMethod("deleteBy" + StringUtils.capitalize((String)attributeParent.getName()), String.class);
                methodDeleteByResourceDb.invoke(repository, resourceDb.toArangoIdentifier());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Unable to update reference");
        }
    }

    private Class<? extends Resource> getResourceClassFromResourceDb(IResourceDb resourceDb) {
        return (Class)((ParameterizedType)resourceDb.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public void updateList(AbstractResourceDb resourceDb, List<? extends AbstractResourceDb> itemsToUpdate, CrudRepository<X, ?> repository) throws Exception {
        HashMap<Action, List<X>> actionsToDo = this.actionsToDo(resourceDb, itemsToUpdate, (Repository<X, ?>)repository);
        actionsToDo.get((Object)Action.ADD).forEach(toAdd -> repository.save(toAdd));
        actionsToDo.get((Object)Action.UPDATE).forEach(toUpdate -> repository.save(toUpdate));
        actionsToDo.get((Object)Action.DELETE).forEach(toDelete -> repository.delete(toDelete));
    }

    private HashMap<Action, List<X>> actionsToDo(AbstractResourceDb resourceDb, List<? extends AbstractResourceDb> resourcesItemsNew, Repository<X, ?> repository) throws Exception {
        HashMap<Action, List<X>> actionsToDo = new HashMap<Action, List<X>>();
        Field attributeParent = this.getEdgeAttribute(resourceDb.getClass());
        if (attributeParent.getAnnotation(From.class) == null && attributeParent.getAnnotation(To.class) == null) {
            throw new IllegalStateException("Attribute " + attributeParent.getName() + " class " + this.typeParameterClass.getClass() + " doesn't have annotation @From or @To");
        }
        Field attributeChild = this.getEdgeAttributeFromAnnotation(attributeParent.getAnnotation(From.class) != null ? To.class : From.class);
        List<X> existingEdges = this.getExistingEdge(resourceDb, repository, attributeParent);
        actionsToDo.put(Action.DELETE, this.getEdgesToDelete(resourcesItemsNew, attributeChild, existingEdges));
        actionsToDo.put(Action.UPDATE, (List<X>)ImmutableList.of());
        actionsToDo.put(Action.ADD, this.getEdgesToAdd(resourceDb, resourcesItemsNew, attributeParent, attributeChild, existingEdges));
        if (Resource.StatusEnum.DELETED.equals((Object)resourceDb.getStatus())) {
            actionsToDo.get((Object)Action.DELETE).addAll((Collection)actionsToDo.get((Object)Action.ADD));
            actionsToDo.put(Action.ADD, (List<X>)ImmutableList.of());
            actionsToDo.get((Object)Action.DELETE).addAll((Collection)actionsToDo.get((Object)Action.UPDATE));
            actionsToDo.put(Action.UPDATE, (List<X>)ImmutableList.of());
        }
        return actionsToDo;
    }

    private List<X> getExistingEdge(AbstractResourceDb object, Repository<X, ?> repository, Field attributeParent) throws Exception {
        String methodNameExcepted = PREFIX_METHOD_REPOSITORY + StringUtils.capitalize((String)attributeParent.getName());
        try {
            Method methodFindAllByResource = repository.getClass().getMethod(methodNameExcepted, String.class);
            try {
                return (List)methodFindAllByResource.invoke(repository, object.toArangoIdentifier());
            }
            catch (Exception e) {
                logger.error((Object)("Unable to execute method " + methodNameExcepted + "(\"" + object.toArangoIdentifier() + "\") on instance of " + repository.getClass().getName() + "."), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find method : " + methodNameExcepted + "(String object) into class " + repository.getClass().getName());
        }
    }

    private List<X> getEdgesToAdd(AbstractResourceDb resourceDb, List<? extends AbstractResourceDb> resourcesItemsNew, Field attributeParent, Field attributeChild, List existingEdges) {
        return resourcesItemsNew.stream().filter(defined -> !Resource.StatusEnum.DELETED.equals((Object)defined.getStatus()) && existingEdges.stream().noneMatch(existingChild -> {
            try {
                AbstractResourceDb resource = (AbstractResourceDb)attributeChild.get(existingChild);
                return resource != null && resource.getId() != null && resource.getId().equals(defined.getId());
            }
            catch (Exception e) {
                if (e instanceof NoSuchElementException) {
                    return false;
                }
                logger.error((Object)("Unable to get instance from property " + attributeChild.getName() + " into class " + existingChild.getClass().toString()), (Throwable)e);
                throw new RuntimeException(e);
            }
        })).map(childToAdd -> this.getNewInstanceOfEdge(resourceDb, attributeParent, attributeChild, (AbstractResourceDb)childToAdd)).collect(Collectors.toList());
    }

    private List<X> getEdgesToDelete(List<? extends AbstractResourceDb> resourcesItemsNew, Field attributeChild, List existingEdges) {
        return existingEdges.stream().filter(existing -> resourcesItemsNew.stream().filter(i -> !Resource.StatusEnum.DELETED.equals((Object)i.getStatus())).noneMatch(defined -> {
            try {
                AbstractResourceDb resource = (AbstractResourceDb)attributeChild.get(existing);
                return resource != null && resource.getId() != null && defined.getId().equals(resource.getId());
            }
            catch (Exception e) {
                if (e instanceof NoSuchElementException) {
                    return false;
                }
                logger.error((Object)("Unable to get instance from property " + attributeChild.getName() + " into class " + existing.getClass().toString()), (Throwable)e);
                throw new RuntimeException(e);
            }
        })).collect(Collectors.toList());
    }

    private PropertyDescriptor getPropertyDescriptorFromField(Field field) {
        return Arrays.stream(this.propertiesDescriptors).filter(propertyDescriptor -> propertyDescriptor.getPropertyType().isAssignableFrom(field.getType()) && propertyDescriptor.getName().equals(field.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find property descriptor for field " + field.getName() + " into class " + this.typeParameterClass.getName()));
    }

    private X getNewInstanceOfEdge(AbstractResourceDb resourceDb, Field attributeParent, Field attributeChild, AbstractResourceDb childToAdd) {
        try {
            Object edge;
            ImmutableList objectsToConstructor = ImmutableList.of((Object)resourceDb, (Object)childToAdd);
            PropertyDescriptor propertyParent = this.getPropertyDescriptorFromField(attributeParent);
            PropertyDescriptor propertyChild = this.getPropertyDescriptorFromField(attributeChild);
            if (attributeParent.getType().equals(attributeChild.getType())) {
                Constructor<X> defaultConstructor = this.typeParameterClass.getConstructor(new Class[0]);
                edge = defaultConstructor.newInstance(new Object[0]);
                propertyParent.getWriteMethod().invoke(edge, resourceDb);
                propertyChild.getWriteMethod().invoke(edge, childToAdd);
            } else {
                Pair constructorFound = Arrays.stream(this.typeParameterClass.getConstructors()).map(arg_0 -> EdgeUtils.lambda$getNewInstanceOfEdge$14((List)objectsToConstructor, arg_0)).filter(arg_0 -> EdgeUtils.lambda$getNewInstanceOfEdge$15((List)objectsToConstructor, arg_0)).sorted(Comparator.comparing(pairConstructAndArgs -> ((HashMap)pairConstructAndArgs.getValue()).size())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find constructor"));
                edge = ((Constructor)constructorFound.getKey()).newInstance(((HashMap)constructorFound.getValue()).values().toArray());
            }
            if (propertyParent.getReadMethod() != null && !resourceDb.equals(propertyParent.getReadMethod().invoke(edge, new Object[0]))) {
                throw new IllegalStateException("Property " + resourceDb.getName() + " of class " + edge.getClass().getName() + " is not matching");
            }
            if (propertyChild.getReadMethod() != null && !childToAdd.equals(propertyChild.getReadMethod().invoke(edge, new Object[0]))) {
                throw new IllegalStateException("Property " + attributeChild.getName() + " of class " + edge.getClass().getName() + " is not matching");
            }
            return (X)edge;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create new edge instance of class " + this.typeParameterClass.getName() + ", add constructor taking 2 arguments: " + attributeChild.getType().getName() + " " + attributeChild.getName() + ",  " + attributeParent.getType().getName() + " " + attributeParent.getName() + ",  "), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Field getEdgeAttribute(Class<?> targetClass) {
        List fields = Arrays.stream(this.typeParameterClass.getDeclaredFields()).filter(field -> field.getType().equals(targetClass) || field.getType().isAssignableFrom(targetClass)).collect(Collectors.toList());
        if (fields.size() == 0) {
            throw new IllegalArgumentException("Unable to find attribute of " + targetClass.getName() + " into class " + this.typeParameterClass.getName());
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Unable to find uniq attribute of " + targetClass.getName() + " into class " + this.typeParameterClass.getName());
        }
        return (Field)fields.get(0);
    }

    private Field getEdgeAttribute(Class<?> targetClass, String nameField) {
        List fields = Arrays.stream(this.typeParameterClass.getDeclaredFields()).filter(field -> field.getType().equals(targetClass) || field.getType().isAssignableFrom(targetClass)).filter(field -> field.getName().equals(nameField)).collect(Collectors.toList());
        if (fields.size() == 0) {
            throw new IllegalArgumentException("Unable to find attribute of " + targetClass.getName() + " into class " + this.typeParameterClass.getName());
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Unable to find uniq attribute of " + targetClass.getName() + " into class " + this.typeParameterClass.getName());
        }
        return (Field)fields.get(0);
    }

    private Field getEdgeAttributeFromAnnotation(Class<? extends Annotation> annotationClass) {
        return Arrays.stream(this.typeParameterClass.getDeclaredFields()).filter(field -> Arrays.stream(field.getAnnotations()).anyMatch(fieldAnnotation -> fieldAnnotation.annotationType().equals(annotationClass))).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find attribute with annotation " + annotationClass.getName() + " into class " + this.typeParameterClass.getName()));
    }

    private static /* synthetic */ boolean lambda$getNewInstanceOfEdge$15(List objectsToConstructor, Pair pairConstructAndArgs) {
        return ((HashMap)pairConstructAndArgs.getValue()).values().containsAll(objectsToConstructor);
    }

    private static /* synthetic */ Pair lambda$getNewInstanceOfEdge$14(List objectsToConstructor, Constructor constructor) {
        HashMap<Integer, Object> args = new HashMap<Integer, Object>();
        int i = 0;
        for (Class<?> parameterizedType : constructor.getParameterTypes()) {
            args.put(i, objectsToConstructor.stream().filter(object -> parameterizedType.equals(object.getClass())).findFirst().orElse(null));
            ++i;
        }
        return Pair.of((Object)constructor, args);
    }

    private static enum Action {
        ADD,
        UPDATE,
        DELETE;

    }
}

