/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.resourcemanager.sourcerepository.dao;

import com.arangodb.springframework.core.ArangoOperations;
import fr.xebia.extras.selma.Selma;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kathra.core.model.SourceRepository;
import org.kathra.resourcemanager.resource.dao.AbstractResourceDao;
import org.kathra.resourcemanager.resource.utils.LeanResourceDbUtils;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryDb;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryMapper;
import org.kathra.resourcemanager.sourcerepository.dao.SourceRepositoryRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSourceRepositoryDao
extends AbstractResourceDao<SourceRepository, SourceRepositoryDb, String> {
    SourceRepositoryMapper mapper = (SourceRepositoryMapper)Selma.mapper(SourceRepositoryMapper.class);

    public AbstractSourceRepositoryDao(@Autowired SourceRepositoryRepository repository, @Autowired ArangoOperations operations) {
        super(repository, operations);
    }

    @PostConstruct
    public void initCollectionIfNotExist() {
        if (this.repository.count() == 0L) {
            try {
                this.operations.insert((Object)new SourceRepositoryDb("init"));
                this.repository.deleteById((Object)"init");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void create(SourceRepository object, String author) throws Exception {
        super.create(object, author);
        this.updateReferences(object);
    }

    @Override
    public void update(SourceRepository object, String author) throws Exception {
        super.update(object, author);
        this.updateReferences(object);
    }

    @Override
    public void delete(SourceRepository object, String author) throws Exception {
        super.delete(object, author);
        this.updateReferences(object);
    }

    private void updateReferences(SourceRepository object) throws Exception {
        SourceRepositoryDb resourceDb = this.convertResourceToResourceDb(object);
    }

    @Override
    public SourceRepositoryDb convertResourceToResourceDb(SourceRepository object) {
        return this.mapper.asSourceRepositoryDb(object);
    }

    @Override
    public SourceRepository convertResourceDbToResource(SourceRepositoryDb object) {
        LeanResourceDbUtils<SourceRepositoryDb> leanResourceDbUtils = new LeanResourceDbUtils<SourceRepositoryDb>();
        return this.mapper.asSourceRepository(leanResourceDbUtils.leanResourceDb(object));
    }

    @Override
    public Stream<SourceRepository> convertResourceDbToResource(Stream<SourceRepositoryDb> objectsStream) {
        LeanResourceDbUtils leanUtils = new LeanResourceDbUtils();
        return objectsStream.map(i -> leanUtils.leanResourceDb(i)).collect(Collectors.toList()).parallelStream().map(i -> this.mapper.asSourceRepository((SourceRepositoryDb)i));
    }
}

