/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.core.model.Membership;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.sourcemanager.model.Folder;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class SourceManagerClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("SourceManagerClient 1.0.0");

    public SourceManagerClient() {
    }

    public SourceManagerClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public SourceManagerClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addMembershipsCall(List<Membership> memberships, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<Membership> localVarPostBody = memberships;
        String localVarPath = "/batch/memberships";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addMembershipsValidateBeforeCall(List<Membership> memberships, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (memberships == null) {
            throw new ApiException("Missing the required parameter 'memberships' when calling addMemberships(Async)");
        }
        Call call = this.addMembershipsCall(memberships, progressListener, progressRequestListener);
        return call;
    }

    public ApiResponse addMemberships(List<Membership> memberships) throws ApiException {
        ApiResponse<ApiResponse> resp = this.addMembershipsWithHttpInfo(memberships);
        return (ApiResponse)resp.getData();
    }

    public ApiResponse<ApiResponse> addMembershipsWithHttpInfo(List<Membership> memberships) throws ApiException {
        Call call = this.addMembershipsValidateBeforeCall(memberships, null, null);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addMembershipsAsync(List<Membership> memberships, ApiCallback<ApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.addMembershipsValidateBeforeCall(memberships, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createBranchCall(String sourceRepositoryPath, String branch, String branchRef, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = branch;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/branches".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (branchRef != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("branchRef", (Object)branchRef));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createBranchValidateBeforeCall(String sourceRepositoryPath, String branch, String branchRef, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling createBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createBranch(Async)");
        }
        Call call = this.createBranchCall(sourceRepositoryPath, branch, branchRef, progressListener, progressRequestListener);
        return call;
    }

    public String createBranch(String sourceRepositoryPath, String branch, String branchRef) throws ApiException {
        ApiResponse<String> resp = this.createBranchWithHttpInfo(sourceRepositoryPath, branch, branchRef);
        return (String)resp.getData();
    }

    public ApiResponse<String> createBranchWithHttpInfo(String sourceRepositoryPath, String branch, String branchRef) throws ApiException {
        Call call = this.createBranchValidateBeforeCall(sourceRepositoryPath, branch, branchRef, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createBranchAsync(String sourceRepositoryPath, String branch, String branchRef, ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.createBranchValidateBeforeCall(sourceRepositoryPath, branch, branchRef, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createCommitCall(String sourceRepositoryPath, String branch, File file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/branches/{branch}/commits".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString())).replaceAll("\\{branch\\}", this.apiClient.escapeString(branch.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (filepath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filepath", (Object)filepath));
        }
        if (uncompress != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("uncompress", (Object)uncompress));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", (Object)tag));
        }
        if (replaceRepositoryContent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("replaceRepositoryContent", (Object)replaceRepositoryContent));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, File> localVarFormParams = new HashMap<String, File>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createCommitValidateBeforeCall(String sourceRepositoryPath, String branch, File file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling createCommit(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createCommit(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling createCommit(Async)");
        }
        Call call = this.createCommitCall(sourceRepositoryPath, branch, file, filepath, uncompress, tag, replaceRepositoryContent, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepositoryCommit createCommit(String sourceRepositoryPath, String branch, File file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent) throws ApiException {
        ApiResponse<SourceRepositoryCommit> resp = this.createCommitWithHttpInfo(sourceRepositoryPath, branch, file, filepath, uncompress, tag, replaceRepositoryContent);
        return (SourceRepositoryCommit)resp.getData();
    }

    public ApiResponse<SourceRepositoryCommit> createCommitWithHttpInfo(String sourceRepositoryPath, String branch, File file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent) throws ApiException {
        Call call = this.createCommitValidateBeforeCall(sourceRepositoryPath, branch, file, filepath, uncompress, tag, replaceRepositoryContent, null, null);
        Type localVarReturnType = new TypeToken<SourceRepositoryCommit>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createCommitAsync(String sourceRepositoryPath, String branch, File file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent, ApiCallback<SourceRepositoryCommit> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.createCommitValidateBeforeCall(sourceRepositoryPath, branch, file, filepath, uncompress, tag, replaceRepositoryContent, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepositoryCommit>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createDeployKeyCall(String keyName, String sshPublicKey, String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = sshPublicKey;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/deployKeys".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (keyName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyName", (Object)keyName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createDeployKeyValidateBeforeCall(String keyName, String sshPublicKey, String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyName == null) {
            throw new ApiException("Missing the required parameter 'keyName' when calling createDeployKey(Async)");
        }
        if (sshPublicKey == null) {
            throw new ApiException("Missing the required parameter 'sshPublicKey' when calling createDeployKey(Async)");
        }
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling createDeployKey(Async)");
        }
        Call call = this.createDeployKeyCall(keyName, sshPublicKey, sourceRepositoryPath, progressListener, progressRequestListener);
        return call;
    }

    public ApiResponse createDeployKey(String keyName, String sshPublicKey, String sourceRepositoryPath) throws ApiException {
        ApiResponse<ApiResponse> resp = this.createDeployKeyWithHttpInfo(keyName, sshPublicKey, sourceRepositoryPath);
        return (ApiResponse)resp.getData();
    }

    public ApiResponse<ApiResponse> createDeployKeyWithHttpInfo(String keyName, String sshPublicKey, String sourceRepositoryPath) throws ApiException {
        Call call = this.createDeployKeyValidateBeforeCall(keyName, sshPublicKey, sourceRepositoryPath, null, null);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createDeployKeyAsync(String keyName, String sshPublicKey, String sourceRepositoryPath, ApiCallback<ApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.createDeployKeyValidateBeforeCall(keyName, sshPublicKey, sourceRepositoryPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createFolderCall(Folder folder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Folder localVarPostBody = folder;
        String localVarPath = "/folders";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createFolderValidateBeforeCall(Folder folder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folder == null) {
            throw new ApiException("Missing the required parameter 'folder' when calling createFolder(Async)");
        }
        Call call = this.createFolderCall(folder, progressListener, progressRequestListener);
        return call;
    }

    public Folder createFolder(Folder folder) throws ApiException {
        ApiResponse<Folder> resp = this.createFolderWithHttpInfo(folder);
        return (Folder)resp.getData();
    }

    public ApiResponse<Folder> createFolderWithHttpInfo(Folder folder) throws ApiException {
        Call call = this.createFolderValidateBeforeCall(folder, null, null);
        Type localVarReturnType = new TypeToken<Folder>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createFolderAsync(Folder folder, ApiCallback<Folder> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.createFolderValidateBeforeCall(folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Folder>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSourceRepositoryCall(SourceRepository sourceRepository, List<String> deployKeys, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SourceRepository localVarPostBody = sourceRepository;
        String localVarPath = "/sourceRepositories";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (deployKeys != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "deployKeys", deployKeys));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSourceRepositoryValidateBeforeCall(SourceRepository sourceRepository, List<String> deployKeys, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepository == null) {
            throw new ApiException("Missing the required parameter 'sourceRepository' when calling createSourceRepository(Async)");
        }
        Call call = this.createSourceRepositoryCall(sourceRepository, deployKeys, progressListener, progressRequestListener);
        return call;
    }

    public SourceRepository createSourceRepository(SourceRepository sourceRepository, List<String> deployKeys) throws ApiException {
        ApiResponse<SourceRepository> resp = this.createSourceRepositoryWithHttpInfo(sourceRepository, deployKeys);
        return (SourceRepository)resp.getData();
    }

    public ApiResponse<SourceRepository> createSourceRepositoryWithHttpInfo(SourceRepository sourceRepository, List<String> deployKeys) throws ApiException {
        Call call = this.createSourceRepositoryValidateBeforeCall(sourceRepository, deployKeys, null, null);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSourceRepositoryAsync(SourceRepository sourceRepository, List<String> deployKeys, ApiCallback<SourceRepository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.createSourceRepositoryValidateBeforeCall(sourceRepository, deployKeys, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SourceRepository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteMembershipsCall(List<Membership> memberships, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<Membership> localVarPostBody = memberships;
        String localVarPath = "/batch/memberships";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteMembershipsValidateBeforeCall(List<Membership> memberships, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (memberships == null) {
            throw new ApiException("Missing the required parameter 'memberships' when calling deleteMemberships(Async)");
        }
        Call call = this.deleteMembershipsCall(memberships, progressListener, progressRequestListener);
        return call;
    }

    public ApiResponse deleteMemberships(List<Membership> memberships) throws ApiException {
        ApiResponse<ApiResponse> resp = this.deleteMembershipsWithHttpInfo(memberships);
        return (ApiResponse)resp.getData();
    }

    public ApiResponse<ApiResponse> deleteMembershipsWithHttpInfo(List<Membership> memberships) throws ApiException {
        Call call = this.deleteMembershipsValidateBeforeCall(memberships, null, null);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteMembershipsAsync(List<Membership> memberships, ApiCallback<ApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteMembershipsValidateBeforeCall(memberships, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSourceRepositoryCall(String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSourceRepositoryValidateBeforeCall(String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling deleteSourceRepository(Async)");
        }
        Call call = this.deleteSourceRepositoryCall(sourceRepositoryPath, progressListener, progressRequestListener);
        return call;
    }

    public String deleteSourceRepository(String sourceRepositoryPath) throws ApiException {
        ApiResponse<String> resp = this.deleteSourceRepositoryWithHttpInfo(sourceRepositoryPath);
        return (String)resp.getData();
    }

    public ApiResponse<String> deleteSourceRepositoryWithHttpInfo(String sourceRepositoryPath) throws ApiException {
        Call call = this.deleteSourceRepositoryValidateBeforeCall(sourceRepositoryPath, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSourceRepositoryAsync(String sourceRepositoryPath, ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.deleteSourceRepositoryValidateBeforeCall(sourceRepositoryPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBranchesCall(String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/branches".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBranchesValidateBeforeCall(String sourceRepositoryPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling getBranches(Async)");
        }
        Call call = this.getBranchesCall(sourceRepositoryPath, progressListener, progressRequestListener);
        return call;
    }

    public List<String> getBranches(String sourceRepositoryPath) throws ApiException {
        ApiResponse<List<String>> resp = this.getBranchesWithHttpInfo(sourceRepositoryPath);
        return (List)resp.getData();
    }

    public ApiResponse<List<String>> getBranchesWithHttpInfo(String sourceRepositoryPath) throws ApiException {
        Call call = this.getBranchesValidateBeforeCall(sourceRepositoryPath, null, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBranchesAsync(String sourceRepositoryPath, ApiCallback<List<String>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getBranchesValidateBeforeCall(sourceRepositoryPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCommitsCall(String sourceRepositoryPath, String branch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/branches/{branch}/commits".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString())).replaceAll("\\{branch\\}", this.apiClient.escapeString(branch.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCommitsValidateBeforeCall(String sourceRepositoryPath, String branch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling getCommits(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getCommits(Async)");
        }
        Call call = this.getCommitsCall(sourceRepositoryPath, branch, progressListener, progressRequestListener);
        return call;
    }

    public List<SourceRepositoryCommit> getCommits(String sourceRepositoryPath, String branch) throws ApiException {
        ApiResponse<List<SourceRepositoryCommit>> resp = this.getCommitsWithHttpInfo(sourceRepositoryPath, branch);
        return (List)resp.getData();
    }

    public ApiResponse<List<SourceRepositoryCommit>> getCommitsWithHttpInfo(String sourceRepositoryPath, String branch) throws ApiException {
        Call call = this.getCommitsValidateBeforeCall(sourceRepositoryPath, branch, null, null);
        Type localVarReturnType = new TypeToken<List<SourceRepositoryCommit>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCommitsAsync(String sourceRepositoryPath, String branch, ApiCallback<List<SourceRepositoryCommit>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getCommitsValidateBeforeCall(sourceRepositoryPath, branch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<SourceRepositoryCommit>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFileCall(String sourceRepositoryPath, String branch, String filepath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/branches/{branch}/file".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString())).replaceAll("\\{branch\\}", this.apiClient.escapeString(branch.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (filepath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filepath", (Object)filepath));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFileValidateBeforeCall(String sourceRepositoryPath, String branch, String filepath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling getFile(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getFile(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling getFile(Async)");
        }
        Call call = this.getFileCall(sourceRepositoryPath, branch, filepath, progressListener, progressRequestListener);
        return call;
    }

    public File getFile(String sourceRepositoryPath, String branch, String filepath) throws ApiException {
        ApiResponse<File> resp = this.getFileWithHttpInfo(sourceRepositoryPath, branch, filepath);
        return (File)resp.getData();
    }

    public ApiResponse<File> getFileWithHttpInfo(String sourceRepositoryPath, String branch, String filepath) throws ApiException {
        Call call = this.getFileValidateBeforeCall(sourceRepositoryPath, branch, filepath, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFileAsync(String sourceRepositoryPath, String branch, String filepath, ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getFileValidateBeforeCall(sourceRepositoryPath, branch, filepath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFolderCall(String folderPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/folders/{folderPath}".replaceAll("\\{folderPath\\}", this.apiClient.escapeString(folderPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFolderValidateBeforeCall(String folderPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderPath == null) {
            throw new ApiException("Missing the required parameter 'folderPath' when calling getFolder(Async)");
        }
        Call call = this.getFolderCall(folderPath, progressListener, progressRequestListener);
        return call;
    }

    public Folder getFolder(String folderPath) throws ApiException {
        ApiResponse<Folder> resp = this.getFolderWithHttpInfo(folderPath);
        return (Folder)resp.getData();
    }

    public ApiResponse<Folder> getFolderWithHttpInfo(String folderPath) throws ApiException {
        Call call = this.getFolderValidateBeforeCall(folderPath, null, null);
        Type localVarReturnType = new TypeToken<Folder>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFolderAsync(String folderPath, ApiCallback<Folder> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getFolderValidateBeforeCall(folderPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Folder>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFoldersCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/folders";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFoldersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getFoldersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<Folder> getFolders() throws ApiException {
        ApiResponse<List<Folder>> resp = this.getFoldersWithHttpInfo();
        return (List)resp.getData();
    }

    public ApiResponse<List<Folder>> getFoldersWithHttpInfo() throws ApiException {
        Call call = this.getFoldersValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<Folder>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFoldersAsync(ApiCallback<List<Folder>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getFoldersValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Folder>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getMembershipsCall(String sourceRepositoryPath, String memberType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sourceRepositories/{sourceRepositoryPath}/memberships".replaceAll("\\{sourceRepositoryPath\\}", this.apiClient.escapeString(sourceRepositoryPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (memberType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("memberType", (Object)memberType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMembershipsValidateBeforeCall(String sourceRepositoryPath, String memberType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sourceRepositoryPath == null) {
            throw new ApiException("Missing the required parameter 'sourceRepositoryPath' when calling getMemberships(Async)");
        }
        Call call = this.getMembershipsCall(sourceRepositoryPath, memberType, progressListener, progressRequestListener);
        return call;
    }

    public List<Membership> getMemberships(String sourceRepositoryPath, String memberType) throws ApiException {
        ApiResponse<List<Membership>> resp = this.getMembershipsWithHttpInfo(sourceRepositoryPath, memberType);
        return (List)resp.getData();
    }

    public ApiResponse<List<Membership>> getMembershipsWithHttpInfo(String sourceRepositoryPath, String memberType) throws ApiException {
        Call call = this.getMembershipsValidateBeforeCall(sourceRepositoryPath, memberType, null, null);
        Type localVarReturnType = new TypeToken<List<Membership>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMembershipsAsync(String sourceRepositoryPath, String memberType, ApiCallback<List<Membership>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getMembershipsValidateBeforeCall(sourceRepositoryPath, memberType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Membership>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSourceRepositoriesInFolderCall(String folderPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/folders/{folderPath}/sourceRepositories".replaceAll("\\{folderPath\\}", this.apiClient.escapeString(folderPath.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{"kathra_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSourceRepositoriesInFolderValidateBeforeCall(String folderPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderPath == null) {
            throw new ApiException("Missing the required parameter 'folderPath' when calling getSourceRepositoriesInFolder(Async)");
        }
        Call call = this.getSourceRepositoriesInFolderCall(folderPath, progressListener, progressRequestListener);
        return call;
    }

    public List<SourceRepository> getSourceRepositoriesInFolder(String folderPath) throws ApiException {
        ApiResponse<List<SourceRepository>> resp = this.getSourceRepositoriesInFolderWithHttpInfo(folderPath);
        return (List)resp.getData();
    }

    public ApiResponse<List<SourceRepository>> getSourceRepositoriesInFolderWithHttpInfo(String folderPath) throws ApiException {
        Call call = this.getSourceRepositoriesInFolderValidateBeforeCall(folderPath, null, null);
        Type localVarReturnType = new TypeToken<List<SourceRepository>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSourceRepositoriesInFolderAsync(String folderPath, ApiCallback<List<SourceRepository>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.getSourceRepositoriesInFolderValidateBeforeCall(folderPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<SourceRepository>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

