/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager;

import org.kathra.utils.ConfigManager;

public class Config
extends ConfigManager {
    private String gitlabUrl = this.getProperty("KATHRA_SOURCEMANAGER_GITLAB_URL", "https://git.dev-irtsysx.fr");
    private String gitlabApiToken;
    private String folderNameContainingGitRepos = this.getProperty("KATHRA_SOURCEMANAGER_FOLDER_NAME_CONTAINING_GIT_REPOS", System.getProperty("java.io.tmpdir") + "/kathra-sourcemanager-git-repos");
    private boolean deleteFolderAfterGit;
    private boolean deleteZipFile;
    private String kathraRootGroup;
    private String userManagerUrl;
    private int maximalTryNumberToCreateDirectory = Integer.parseInt(this.getProperty("KATHRA_SOURCEMANAGER_MAXIMAL_TRY_NUMBER_TO_CREATE_DIRECTORY", "3"));

    public Config() {
        this.deleteFolderAfterGit = Boolean.valueOf(this.getProperty("KATHRA_SOURCEMANAGER_DELETE_FOLDER_AFTER_GIT", "true"));
        this.deleteZipFile = Boolean.valueOf(this.getProperty("KATHRA_SOURCEMANAGER_DELETE_ZIP_FILE", "true"));
        this.gitlabApiToken = this.getProperty("KATHRA_SOURCEMANAGER_GITLAB_API_TOKEN");
        this.kathraRootGroup = this.getProperty("KATHRA_ROOT_GROUP", "kathra-projects");
    }

    public String getGitlabUrl() {
        return this.gitlabUrl;
    }

    public String getGitlabApiToken() {
        return this.gitlabApiToken;
    }

    public String getFolderNameContainingGitRepos() {
        return this.folderNameContainingGitRepos;
    }

    public boolean isDeleteFolderAfterGit() {
        return this.deleteFolderAfterGit;
    }

    public boolean isDeleteZipFile() {
        return this.deleteZipFile;
    }

    public int getMaximalTryNumberToCreateDirectory() {
        return this.maximalTryNumberToCreateDirectory;
    }

    public String getKathraRootGroup() {
        return this.kathraRootGroup;
    }
}

