/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager.controller;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.kathra.core.model.SourceRepositoryCommit;

public class GitService {
    Logger logger = Logger.getLogger((String)GitService.class.getName());
    public static final String GIT_REMOTE = "origin";
    String currentWorkingDirectory = System.getProperty("java.io.tmpdir");

    public Git cloneProject(String projectName, String branch, File workingFolder, CredentialsProvider cp, String projectUrl, Boolean includeTags) throws GitAPIException, InterruptedException {
        Git git;
        CloneCommand cloneCommand;
        LsRemoteCommand lsRemoteCommand = ((LsRemoteCommand)Git.lsRemoteRepository().setTags(true).setHeads(true).setCredentialsProvider(cp)).setRemote(projectUrl);
        Collection remoteRefs = (Collection)this.callWithRetries((TransportCommand)lsRemoteCommand);
        boolean branchExists = false;
        boolean tagExists = false;
        for (Ref remoteRef : remoteRefs) {
            if (remoteRef.getName().equals("refs/heads/" + branch)) {
                branchExists = true;
                break;
            }
            if (!includeTags.booleanValue() || !remoteRef.getName().equals("refs/tags/" + branch)) continue;
            tagExists = true;
            break;
        }
        if (branchExists) {
            cloneCommand = (CloneCommand)Git.cloneRepository().setBranchesToClone(Collections.singleton("refs/heads/" + branch)).setBranch("refs/heads/" + branch).setURI(projectUrl).setDirectory(this.getGitFolderPath(workingFolder, projectName)).setCredentialsProvider(cp);
            git = (Git)this.callWithRetries((TransportCommand)cloneCommand);
        } else if (tagExists) {
            cloneCommand = (CloneCommand)Git.cloneRepository().setURI(projectUrl).setDirectory(this.getGitFolderPath(workingFolder, projectName)).setCredentialsProvider(cp);
            git = (Git)this.callWithRetries((TransportCommand)cloneCommand);
            git.checkout().setName(branch).call();
        } else {
            cloneCommand = (CloneCommand)Git.cloneRepository().setURI(projectUrl).setDirectory(this.getGitFolderPath(workingFolder, projectName)).setCredentialsProvider(cp);
            git = (Git)this.callWithRetries((TransportCommand)cloneCommand);
            git.branchRename().setNewName(branch).call();
        }
        return git;
    }

    public File createWorkingFolder() throws IOException {
        String sessionID = "KathraSourceManager_WorkingFolder_" + UUID.randomUUID().toString();
        File workingFolder = new File(this.currentWorkingDirectory + File.separator + sessionID);
        for (int i = 0; i < 3; ++i) {
            if (!workingFolder.exists()) break;
            workingFolder = new File(this.currentWorkingDirectory + File.separator + "KathraSourceManager_WorkingFolder_" + UUID.randomUUID().toString());
            if (i < 3 || !workingFolder.exists()) continue;
            FileUtils.deleteDirectory((File)workingFolder);
        }
        workingFolder.mkdirs();
        return workingFolder;
    }

    private File getGitFolderPath(File workingFolder, String projectName) {
        return new File(workingFolder.getAbsolutePath() + File.separator + projectName);
    }

    public Iterable<PushResult> pushToGitRepoWithUserCredentials(CredentialsProvider cp, Git git) throws GitAPIException, InterruptedException {
        PushCommand pushCommand = git.push();
        pushCommand.setPushTags();
        pushCommand.setPushAll();
        pushCommand.setRemote(GIT_REMOTE);
        pushCommand.setCredentialsProvider(cp);
        return (Iterable)this.callWithRetries((TransportCommand)pushCommand);
    }

    public Iterable<PushResult> pushTagOnlyToGitRepoWithUserCredentials(CredentialsProvider cp, Git git, boolean force) throws GitAPIException, InterruptedException {
        PushCommand pushCommand = git.push();
        pushCommand.setPushTags();
        pushCommand.setRemote(GIT_REMOTE);
        pushCommand.setCredentialsProvider(cp);
        pushCommand.setForce(force);
        return (Iterable)this.callWithRetries((TransportCommand)pushCommand);
    }

    public SourceRepositoryCommit createCommit(Git git, String username, String message) throws GitAPIException {
        git.add().addFilepattern(".").call();
        git.add().setUpdate(true).addFilepattern(".").call();
        RevCommit call = git.commit().setAuthor(username, username + "@kathra.org").setMessage(message).setCommitter(username, username + "@kathra.org").setAllowEmpty(false).call();
        SourceRepositoryCommit sourceRepositoryCommit = new SourceRepositoryCommit();
        sourceRepositoryCommit.authorEmail(call.getAuthorIdent().getEmailAddress());
        sourceRepositoryCommit.authorName(call.getAuthorIdent().getName());
        sourceRepositoryCommit.committerEmail(call.getCommitterIdent().getEmailAddress());
        sourceRepositoryCommit.committerName(call.getCommitterIdent().getName());
        sourceRepositoryCommit.createdAt(String.valueOf(call.getCommitTime()));
        sourceRepositoryCommit.message(call.getFullMessage());
        sourceRepositoryCommit.id(call.getName());
        sourceRepositoryCommit.shortId(call.getId().abbreviate(8).name());
        sourceRepositoryCommit.title(call.getShortMessage());
        return sourceRepositoryCommit;
    }

    public void createTag(Git git, String tag, boolean force) throws GitAPIException {
        git.tag().setForceUpdate(force).setName(tag).call();
    }

    private <T> T callWithRetries(TransportCommand<? extends GitCommand, T> command) throws GitAPIException, InterruptedException {
        return this.callWithRetries(command, 5, 1000);
    }

    private <T> T callWithRetries(TransportCommand<? extends GitCommand, T> command, int nbMaxAttempts, int millisBetweenAttemps) throws GitAPIException, InterruptedException {
        GitAPIException exception = null;
        for (int attempt = 1; attempt <= nbMaxAttempts; ++attempt) {
            try {
                return (T)command.call();
            }
            catch (GitAPIException e) {
                this.logger.warn((Object)("Git command " + command.getClass().getName() + "failed (" + attempt + "/" + nbMaxAttempts + ")"));
                Thread.sleep(millisBetweenAttemps);
                exception = e;
                continue;
            }
        }
        throw exception;
    }
}

