/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager;

import org.kathra.utils.ConfigManager;

public class Config
extends ConfigManager {
    private final String password;
    private final String username;
    private String gitlabUrl = this.getProperty("KATHRA_SOURCEMANAGER_GITLAB_URL", "https://git.dev-irtsysx.fr");
    private String gitlabApiToken;
    private boolean deleteFolderAfterGit = Boolean.valueOf(this.getProperty("KATHRA_SOURCEMANAGER_DELETE_FOLDER_AFTER_GIT", "true"));
    private String kathraRootGroup;
    private String keycloakHost;
    private String resourceManager;

    public Config() {
        this.gitlabApiToken = this.getProperty("KATHRA_SOURCEMANAGER_GITLAB_API_TOKEN");
        this.kathraRootGroup = this.getProperty("KATHRA_ROOT_GROUP", "kathra-projects");
        this.username = this.getProperty("USERNAME", "");
        this.password = this.getProperty("PASSWORD", "");
        this.resourceManager = this.getProperty("RESOURCE_MANAGER_URL", "");
        this.keycloakHost = this.getProperty("KEYCLOAK_AUTH_URL", "").replace("http://", "").replace("https://", "").replace("/aut.*", "");
    }

    public String getGitlabUrl() {
        return this.gitlabUrl;
    }

    public String getGitlabApiToken() {
        return this.gitlabApiToken;
    }

    public boolean isDeleteFolderAfterGit() {
        return this.deleteFolderAfterGit;
    }

    public String getKathraRootGroup() {
        return this.kathraRootGroup;
    }

    public String getLoginKeycloak() {
        return this.username;
    }

    public String getPasswordKeycloak() {
        return this.password;
    }

    public String getResourceManager() {
        return this.resourceManager;
    }

    public String getKeycloakHost() {
        return this.keycloakHost;
    }

    public String getDelaySchedule() {
        return "30s";
    }
}

