/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager;

import org.kathra.core.model.User;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;
import org.kathra.utils.security.KeycloakUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloackSession
extends Session
implements KathraSessionManager {
    Logger log = LoggerFactory.getLogger((String)"KeycloackSession");
    private SessionToken<String> token = new SessionToken();

    public KeycloackSession(User user) {
        this.log.debug("Creating session for" + user.getName());
        this.callerName(user.getName());
        this.setUserObject(user);
        this.performLogin();
        this.log.debug("Session created for" + user.getName());
    }

    private void performLogin() {
        User sessionUser = this.getUserObject();
        this.log.debug("Performing logging for " + sessionUser.getName());
        String loggin_token = KeycloakUtils.login((String)sessionUser.getName(), (String)sessionUser.getPassword());
        this.log.debug("Token received: " + loggin_token);
        this.token.setToken(loggin_token);
        this.setAccessToken(loggin_token);
        this.authenticated(true);
        this.log.debug("Session confirmed");
    }

    public Session getCurrentSession() {
        return this;
    }

    public void handleSession(Session session) {
    }

    class SessionToken<Type> {
        public Type token;

        SessionToken() {
        }

        public void setToken(Type currentToken) {
            this.token = currentToken;
        }

        public Type token() {
            return this.token;
        }
    }
}

