/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kathra.core.model.User;
import org.kathra.resourcemanager.client.GroupsClient;
import org.kathra.resourcemanager.client.UsersClient;
import org.kathra.sourcemanager.Config;
import org.kathra.sourcemanager.KeycloackSession;
import org.kathra.utils.KathraSessionManager;

public class GitlabGenerateToken
implements Processor {
    private static final Logger logger = Logger.getLogger(GitlabGenerateToken.class.getName());
    private final GroupsClient groupsClient;
    private final UsersClient usersClient;
    private static final String SCRIPT = "generateToken.sh";
    private final String gitlabHost;
    private final String keycloakHost;
    private static GitlabGenerateToken instance;

    public static GitlabGenerateToken getInstance() {
        if (instance == null) {
            Config config = new Config();
            KeycloackSession sessionManager = new KeycloackSession(new User().name(config.getLoginKeycloak()).password(config.getPasswordKeycloak()));
            GroupsClient groupsClient = new GroupsClient(config.getResourceManager(), (KathraSessionManager)sessionManager);
            UsersClient usersClient = new UsersClient(config.getResourceManager(), (KathraSessionManager)sessionManager);
            instance = new GitlabGenerateToken(groupsClient, usersClient, config.getGitlabUrl().replaceAll("https://", "").replaceAll("http://", ""), config.getKeycloakHost());
        }
        return instance;
    }

    public GitlabGenerateToken(GroupsClient groupsClient, UsersClient usersClient, String gitlabHost, String keycloakHost) {
        this.groupsClient = groupsClient;
        this.usersClient = usersClient;
        this.keycloakHost = keycloakHost;
        this.gitlabHost = gitlabHost;
    }

    public void process(Exchange exchange) throws Exception {
        this.copyScriptIntoFs("/tmp/generateToken.sh");
        logger.info("execute");
        this.groupsClient.getGroups().parallelStream().map(g -> g.getTechnicalUser()).filter(Objects::nonNull).forEach(u -> this.execute((User)u));
    }

    public void execute(User user) {
        logger.info("execute for user " + user.getId());
        try {
            String token;
            User userWidthDetails = this.usersClient.getUser(user.getId());
            if (StringUtils.isEmpty((CharSequence)userWidthDetails.getPassword())) {
                throw new IllegalStateException("Not password defined for user:" + userWidthDetails.getName());
            }
            String string = token = userWidthDetails.getMetadata() != null ? (String)userWidthDetails.getMetadata().get("GITLAB_TOKEN") : null;
            if (StringUtils.isEmpty(token)) {
                logger.info("GITLAB_TOKEN undefined for user:" + userWidthDetails.getName());
                token = this.generateToken(this.gitlabHost, this.keycloakHost, userWidthDetails.getName(), userWidthDetails.getPassword());
                this.usersClient.updateUserAttributes(user.getId(), new User().putMetadataItem("GITLAB_TOKEN", (Object)token));
                logger.info("GITLAB_TOKEN updated for user:" + userWidthDetails.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyScriptIntoFs(String path) throws IOException {
        File file = new File(path);
        if (file.isFile()) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resource = classLoader.getResource(SCRIPT);
        FileUtils.copyURLToFile((URL)resource, (File)file);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        Files.setPosixFilePermissions(file.toPath(), perms);
    }

    private String generateToken(String gitlabHost, String keycloakHost, String username, String password) throws IOException {
        File tokenFile = File.createTempFile("/tmp/generate.gitlab", ".txt");
        CharSequence[] cmd = new String[]{"/bin/bash", "/tmp/generateToken.sh", gitlabHost, keycloakHost, username, password, tokenFile.getAbsolutePath()};
        logger.info("generateToken:" + String.join((CharSequence)",", cmd));
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec((String[])cmd);
        try (InputStream stdIn = proc.getInputStream();
             InputStreamReader isr = new InputStreamReader(stdIn);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            int exitVal = 0;
            try {
                exitVal = proc.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while ((line = br.readLine()) != null) {
                logger.info(line);
            }
            logger.info("generateToken:" + String.join((CharSequence)",", cmd) + " exit value:" + exitVal);
            if (exitVal == 0) {
                String string = FileUtils.readFileToString((File)tokenFile, (String)"UTF-8");
                return string;
            }
        }
        throw new IllegalStateException("Not token generated");
    }
}

