/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager.controller;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.GitlabAPIException;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabAccessLevel;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabGroupMember;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabProjectMember;
import org.gitlab.api.models.GitlabUser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kathra.core.model.Membership;
import org.kathra.utils.KathraException;
import org.kathra.utils.Session;
import org.kathra.utils.sanitizing.SanitizeUtils;

public class GitlabService {
    public static final String PRIVATE_TOKEN = "PRIVATE-TOKEN";
    private String host;
    private String apiToken;
    private GitlabAPI adminClient;
    private GitlabAPI userClient;
    protected Session session;
    private String impersonationTokenForUser;
    private Logger logger = Logger.getLogger((String)GitlabService.class.getName());

    public GitlabService(String host, String apiToken, Session session) throws Exception {
        this.host = host;
        this.apiToken = apiToken;
        this.session = session;
        this.adminClient = GitlabAPI.connect((String)host, (String)apiToken);
        this.userClient = this.getGitlabClientForUser();
    }

    private GitlabAPI getGitlabClientForUser() throws UnirestException, IOException {
        this.impersonationTokenForUser = this.retrieveImpersonationTokenForUser();
        if (this.impersonationTokenForUser == null) {
            return GitlabAPI.connect((String)this.host, (String)this.apiToken);
        }
        return GitlabAPI.connect((String)this.host, (String)this.impersonationTokenForUser, (TokenType)TokenType.PRIVATE_TOKEN);
    }

    public String retrieveImpersonationTokenForUser() throws UnirestException, IOException {
        GitlabUser user;
        try {
            user = this.adminClient.getUserViaSudo(this.session.getCallerName());
        }
        catch (Exception e) {
            return null;
        }
        HttpResponse jsonNodeHttpResponse = Unirest.get((String)(this.host + "/api/v4/users/{id}/impersonation_tokens")).routeParam("id", user.getId().toString()).header(PRIVATE_TOKEN, this.apiToken).asJson();
        JSONArray array = ((JsonNode)jsonNodeHttpResponse.getBody()).getArray();
        if (array.length() > 0) {
            for (Object o : array) {
                JSONObject jsonObject = (JSONObject)o;
                if (!jsonObject.has("token") || !jsonObject.get("name").equals("KathraGitlabSourceManager") || !jsonObject.get("revoked").equals(false)) continue;
                return (String)jsonObject.get("token");
            }
        }
        jsonNodeHttpResponse = Unirest.post((String)(this.host + "/api/v4/users/{id}/impersonation_tokens")).header(PRIVATE_TOKEN, this.apiToken).routeParam("id", user.getId().toString()).queryString("name", (Object)"KathraGitlabSourceManager").queryString("scopes[]", Arrays.asList("api", "read_user")).asJson();
        return (String)((JsonNode)jsonNodeHttpResponse.getBody()).getObject().get("token");
    }

    public GitlabAPI getAdminClient() {
        return this.adminClient;
    }

    public GitlabAPI getUserClient() {
        return this.userClient;
    }

    public String getImpersonationTokenForUser() {
        return this.impersonationTokenForUser;
    }

    public GitlabProject getProjectFromPath(String sourceRepositoryPath) throws IOException {
        String sourceRespositoryName;
        String namespace;
        int i = (sourceRepositoryPath = SanitizeUtils.sanitizePathParameter((String)sourceRepositoryPath)).lastIndexOf(47);
        if (i != -1) {
            namespace = sourceRepositoryPath.substring(0, i);
            sourceRespositoryName = sourceRepositoryPath.substring(i + 1);
        } else {
            namespace = "";
            sourceRespositoryName = sourceRepositoryPath;
        }
        return this.adminClient.getProject(namespace, sourceRespositoryName);
    }

    public void addMemberships(List<Membership> memberships) throws Exception {
        for (Membership m : memberships) {
            GitlabUser user;
            try {
                user = this.adminClient.getUserViaSudo(m.getMemberName());
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)("Unable to find member " + m.getMemberName()));
                break;
            }
            try {
                GitlabProject project = this.getProjectFromPath(m.getPath());
                this.adminClient.addProjectMember(project, user, this.membershipRoleToGitlabAccessLevel(m.getRole(), false));
            }
            catch (FileNotFoundException e) {
                GitlabGroup group = this.adminClient.getGroup(SanitizeUtils.sanitizePathParameter((String)m.getPath()));
                try {
                    this.adminClient.addGroupMember(group, user, this.membershipRoleToGitlabAccessLevel(m.getRole(), true));
                }
                catch (GitlabAPIException e2) {
                    if (e2.getResponseCode() == 409) break;
                    throw e;
                }
            }
            catch (GitlabAPIException e) {
                if (e.getResponseCode() == 409) break;
                throw e;
            }
        }
    }

    public void createDeployKey(String keyName, String sshPublicKey, String sourceRepositoryPath) throws Exception {
        this.adminClient.createDeployKey(this.getProjectFromPath(sourceRepositoryPath).getId(), keyName, sshPublicKey);
    }

    public void deleteMemberships(List<Membership> memberships) throws Exception {
        for (Membership m : memberships) {
            GitlabUser user = this.adminClient.getUserViaSudo(m.getMemberName());
            try {
                GitlabProject project = this.getProjectFromPath(m.getPath());
                this.adminClient.deleteProjectMember(project, user);
            }
            catch (FileNotFoundException e) {
                GitlabGroup group = this.adminClient.getGroup(SanitizeUtils.sanitizePathParameter((String)m.getPath()));
                this.adminClient.deleteGroupMember(group, user);
            }
        }
    }

    public List<Membership> getMemberships(String sourceRepositoryPath, String memberType) throws Exception {
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        try {
            GitlabProject project = this.getProjectFromPath(sourceRepositoryPath);
            List projectMembers = this.adminClient.getProjectMembers(project);
            for (GitlabProjectMember m : projectMembers) {
                memberships.add(new Membership().memberName(m.getUsername()).memberType(Membership.MemberTypeEnum.USER).role(this.gitlabAccessLevelToMembershipRole(m.getAccessLevel())));
            }
        }
        catch (FileNotFoundException e) {
            GitlabGroup group;
            try {
                group = this.adminClient.getGroup(SanitizeUtils.sanitizePathParameter((String)sourceRepositoryPath));
            }
            catch (FileNotFoundException e2) {
                throw new KathraException("Unable to find project or group " + sourceRepositoryPath, e2.getCause(), KathraException.ErrorCode.NOT_FOUND);
            }
            List groupMembers = this.adminClient.getGroupMembers(group);
            for (GitlabGroupMember m : groupMembers) {
                memberships.add(new Membership().memberName(m.getUsername()).memberType(Membership.MemberTypeEnum.USER).role(this.gitlabAccessLevelToMembershipRole(m.getAccessLevel())));
            }
        }
        return memberships;
    }

    private Membership.RoleEnum gitlabAccessLevelToMembershipRole(GitlabAccessLevel gitlabAccessLevel) {
        if (gitlabAccessLevel.accessValue <= 20) {
            return Membership.RoleEnum.GUEST;
        }
        if (gitlabAccessLevel.accessValue == 30) {
            return Membership.RoleEnum.CONTRIBUTOR;
        }
        return Membership.RoleEnum.MANAGER;
    }

    private GitlabAccessLevel membershipRoleToGitlabAccessLevel(Membership.RoleEnum membershipRole, boolean isGroup) {
        if (membershipRole.equals((Object)Membership.RoleEnum.GUEST)) {
            return GitlabAccessLevel.Reporter;
        }
        if (membershipRole.equals((Object)Membership.RoleEnum.CONTRIBUTOR)) {
            return GitlabAccessLevel.Developer;
        }
        if (membershipRole.equals((Object)Membership.RoleEnum.MANAGER)) {
            if (isGroup) {
                return GitlabAccessLevel.Owner;
            }
            return GitlabAccessLevel.Master;
        }
        return GitlabAccessLevel.Guest;
    }
}

