/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.sourcemanager.controller;

import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javassist.NotFoundException;
import javax.activation.FileDataSource;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gitlab.api.GitlabAPIException;
import org.gitlab.api.models.CreateGroupRequest;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabCommit;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabTag;
import org.json.JSONArray;
import org.kathra.core.model.Membership;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.sourcemanager.Config;
import org.kathra.sourcemanager.controller.GitService;
import org.kathra.sourcemanager.controller.GitlabService;
import org.kathra.sourcemanager.model.Folder;
import org.kathra.sourcemanager.service.SourceManagerService;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraException;
import org.kathra.utils.sanitizing.SanitizeUtils;
import org.zeroturnaround.zip.ZipUtil;

@Named(value="SourceManagerController")
@ContextName(value="SourceManager")
public class SourceManagerController
implements SourceManagerService {
    public static final String PRIVATE_TOKEN = "PRIVATE-TOKEN";
    private GitlabService gitlabService;
    protected GitService gitService;
    private Config config = new Config();
    private int maxAttempt = 5;
    private int attemptWaitMs = 250;
    Logger logger = Logger.getLogger((String)SourceManagerController.class.getName());

    public SourceManagerController() throws Exception {
        this.gitService = new GitService();
        this.gitlabService = new GitlabService(this.config.getGitlabUrl(), this.config.getGitlabApiToken(), this.getCurrentSession());
    }

    public SourceManagerController(GitlabService gitlabService) throws Exception {
        this.gitlabService = gitlabService;
        this.gitService = new GitService();
    }

    public String createBranch(String sourceRepositoryPath, String branch, String branchRef) throws Exception {
        if (branchRef == null || branchRef.isEmpty()) {
            branchRef = "master";
        }
        GitlabProject projectFromPath = this.gitlabService.getProjectFromPath(sourceRepositoryPath);
        this.gitlabService.getUserClient().createBranch((Serializable)projectFromPath.getId(), branch, branchRef);
        GitlabBranch gitlabBranch = this.gitlabService.getUserClient().getBranch((Serializable)projectFromPath.getId(), branch);
        return gitlabBranch.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceRepositoryCommit createCommit(String sourceRepositoryPath, String branch, FileDataSource file, String filepath, Boolean uncompress, String tag, Boolean replaceRepositoryContent) throws Exception {
        SourceRepositoryCommit sourceRepositoryCommit;
        String folderPath = "";
        String fileName = null;
        if (uncompress == null) {
            uncompress = false;
        }
        if (filepath != null) {
            int index = filepath.lastIndexOf("/");
            if (index == -1) {
                fileName = filepath;
            } else if (index == filepath.length() - 1) {
                folderPath = filepath;
            } else {
                folderPath = filepath.substring(0, index);
                fileName = filepath.substring(index + 1);
            }
        }
        File permFile = this.tmpFileToPermanentFile(file.getFile(), fileName);
        File workingFolder = null;
        try {
            SourceRepositoryCommit commit;
            String username = this.gitlabService.session.getCallerName();
            GitlabProject project = this.getGitlabProject(sourceRepositoryPath);
            String projectName = project.getName();
            workingFolder = this.gitService.createWorkingFolder();
            CredentialsProvider cp = this.getCredentialProviders();
            Git git = this.gitService.cloneProject(projectName, branch, workingFolder, cp, project.getHttpUrl(), false);
            File projectFolder = new File(workingFolder, projectName);
            if (replaceRepositoryContent != null && replaceRepositoryContent.booleanValue()) {
                File[] files;
                for (File fileToDelete : files = projectFolder.listFiles()) {
                    if (fileToDelete.getName().equals(".git")) continue;
                    FileUtils.forceDelete((File)fileToDelete);
                }
            }
            if (uncompress != null && uncompress.booleanValue()) {
                ZipUtil.unpack((File)permFile, (File)projectFolder);
            } else {
                File destPath = !folderPath.isEmpty() ? new File(projectFolder, folderPath) : projectFolder;
                FileUtils.copyFileToDirectory((File)permFile, (File)destPath, (boolean)true);
            }
            Status status = git.status().call();
            if (status.hasUncommittedChanges() || !status.getUntracked().isEmpty()) {
                commit = this.gitService.createCommit(git, username, "Update autogenerated components");
                this.gitService.pushToGitRepoWithUserCredentials(cp, git);
                if (StringUtils.isNotEmpty((CharSequence)tag)) {
                    this.gitService.createTag(git, tag, true);
                    this.gitService.pushTagOnlyToGitRepoWithUserCredentials(cp, git, true);
                }
            } else {
                throw new KathraException("No changes detected, aborting request.").errorCode(KathraException.ErrorCode.NOT_MODIFIED);
            }
            sourceRepositoryCommit = commit;
        }
        catch (Throwable throwable) {
            try {
                if (workingFolder == null && this.config.isDeleteFolderAfterGit()) {
                    FileUtils.forceDelete(workingFolder);
                    FileUtils.deleteDirectory(workingFolder);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                FileUtils.deleteQuietly((File)permFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (workingFolder == null && this.config.isDeleteFolderAfterGit()) {
                FileUtils.forceDelete((File)workingFolder);
                FileUtils.deleteDirectory((File)workingFolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FileUtils.deleteQuietly((File)permFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sourceRepositoryCommit;
    }

    public Folder createFolder(Folder folder) throws Exception {
        GitlabGroup gitlabGroup;
        Path path = Paths.get(SanitizeUtils.sanitizePathParameter((String)folder.getPath()), new String[0]);
        Path parentPath = path.getParent();
        String groupName = path.getFileName().toString();
        try {
            GitlabGroup parent = null;
            if (parentPath != null) {
                try {
                    parent = this.gitlabService.getAdminClient().getGroup(parentPath.toString());
                }
                catch (FileNotFoundException e) {
                    parent = this.createFolderHierarchyIfNotExists(parentPath);
                }
            }
            GitlabGroup existingGroup = null;
            try {
                existingGroup = this.gitlabService.getUserClient().getGroup(path.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            gitlabGroup = existingGroup != null ? existingGroup : this.gitlabService.getUserClient().createGroup(groupName, groupName, null, null, null, parent.getId());
        }
        catch (GitlabAPIException e) {
            throw new ApiException(409, "A group with the same name already exists at the requested path");
        }
        folder = this.convertGitlabGroupToFolder(gitlabGroup);
        return folder;
    }

    public String deleteSourceRepository(String sourceRepositoryPath) throws Exception {
        try {
            GitlabProject project = this.gitlabService.getProjectFromPath(sourceRepositoryPath);
            if (project == null) {
                throw new KathraException("No project found.").errorCode(KathraException.ErrorCode.NOT_FOUND);
            }
            this.gitlabService.getUserClient().deleteProject((Serializable)project.getId());
        }
        catch (KathraException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KathraException("Internal error.").errorCode(KathraException.ErrorCode.INTERNAL_SERVER_ERROR);
        }
        return "OK";
    }

    public SourceRepository createSourceRepository(SourceRepository sourceRepository, List<String> deployKeys) throws Exception {
        GitlabGroup group;
        Path path = Paths.get(SanitizeUtils.sanitizePathParameter((String)sourceRepository.getPath()), new String[0]);
        Path parentPath = path.getParent();
        String sourceRepoName = path.getFileName().toString();
        Map keysMap = deployKeys != null && !deployKeys.isEmpty() ? this.checkDeployKeysExists(deployKeys) : new HashMap();
        try {
            group = this.gitlabService.getUserClient().getGroup(parentPath.toString());
        }
        catch (FileNotFoundException e) {
            group = this.createFolderHierarchyIfNotExists(parentPath);
        }
        if (group == null) {
            throw new KathraException("Unable to create gitlab project for provided path: " + parentPath).errorCode(KathraException.ErrorCode.SERVICE_UNAVAILABLE);
        }
        try {
            GitlabProject gitlabProject2 = this.gitlabService.getUserClient().createProjectForGroup(sourceRepoName, group);
            for (Integer keyId : keysMap.values()) {
                this.enableDeployKeyForProject(gitlabProject2, keyId);
            }
            if (gitlabProject2 == null) {
                throw new KathraException("Cannot create the project " + sourceRepository.getName() + " in the group path: (" + parentPath + ", " + group.getName() + ")").errorCode(KathraException.ErrorCode.SERVICE_UNAVAILABLE);
            }
            sourceRepository = this.map(sourceRepository, gitlabProject2);
            this.createDefaultsBranches(gitlabProject2);
            return sourceRepository;
        }
        catch (Exception e) {
            if (e.getMessage().contains("has already been taken")) {
                Optional<GitlabProject> existingProject = this.gitlabService.getUserClient().getGroupProjects(group).stream().filter(gitlabProject -> gitlabProject.getName().equals(sourceRepoName)).findFirst();
                if (existingProject.isPresent()) {
                    this.createDefaultsBranches(existingProject.get());
                    return this.map(sourceRepository, existingProject.get());
                }
                throw new ApiException(409, "A source repository with the same name already exists at the requested path");
            }
            throw new KathraException("Cannot create the project " + sourceRepository.getName() + " in the group: (" + group.getName() + ") caused by " + e.getMessage(), (Throwable)e).errorCode(KathraException.ErrorCode.SERVICE_UNAVAILABLE);
        }
    }

    private SourceRepository map(SourceRepository sourceRepository, GitlabProject gitlabProject) {
        sourceRepository.httpUrl(gitlabProject.getHttpUrl()).sshUrl(gitlabProject.getSshUrl()).webUrl(gitlabProject.getWebUrl()).provider("gitlab").providerId(String.valueOf(gitlabProject.getId()));
        return sourceRepository;
    }

    private void createDefaultsBranches(GitlabProject gitlabProject) throws Exception {
        Throwable lastException;
        int attempt = 0;
        while (true) {
            try {
                this.gitlabService.getUserClient().createBranch(gitlabProject, "dev", "master");
                lastException = null;
            }
            catch (Exception e) {
                long wait = (long)((double)this.attemptWaitMs * Math.pow(2.0, attempt));
                try {
                    GitlabBranch devBranch = this.gitlabService.getUserClient().getBranch(gitlabProject, "dev");
                    if (devBranch != null && devBranch.getCommit() != null && devBranch.getCommit().getId() != null) {
                        this.logger.info((Object)("Gitlab has thrown an exception, however the branches has been created (" + e.getMessage() + ")"));
                        lastException = null;
                        break;
                    }
                }
                catch (Exception e1) {
                    this.logger.warn((Object)("Gitlab has thrown an exception, branches has not been created : " + e1.getMessage()));
                }
                this.logger.warn((Object)("Unable to create branches for repository " + gitlabProject.getPath() + ", wait  " + wait + " ms and retry (" + attempt + "/" + this.maxAttempt + ")"));
                lastException = e;
                Thread.sleep(wait);
                if (++attempt < this.maxAttempt) continue;
            }
            break;
        }
        if (lastException != null) {
            lastException.printStackTrace();
            throw lastException;
        }
    }

    private Map checkDeployKeysExists(List<String> deployKeys) throws Exception {
        HashMap keysMap = new HashMap();
        JSONArray array = ((JsonNode)Unirest.get((String)(this.config.getGitlabUrl() + "/api/v4/deploy_keys")).queryString("per_page", (Object)"1000000").header(PRIVATE_TOKEN, this.config.getGitlabApiToken()).asJson().getBody()).getArray();
        IntStream.range(0, array.length()).mapToObj(arg_0 -> ((JSONArray)array).getJSONObject(arg_0)).forEach(obj -> keysMap.put((String)obj.get("title"), (Integer)obj.get("id")));
        HashMap<String, Integer> keysMapToReturn = new HashMap<String, Integer>();
        for (String title : deployKeys) {
            if (!keysMap.containsKey(title)) {
                throw new KathraException("Unable to find deploy key " + title).errorCode(KathraException.ErrorCode.NOT_FOUND);
            }
            keysMapToReturn.put(title, (Integer)keysMap.get(title));
        }
        return keysMapToReturn;
    }

    private void enableDeployKeyForProject(GitlabProject p, Integer keyId) throws UnirestException {
        Unirest.post((String)(this.config.getGitlabUrl() + "/api/v4/projects/{projectId}/deploy_keys/{keyId}/enable")).header(PRIVATE_TOKEN, this.config.getGitlabApiToken()).routeParam("projectId", p.getId().toString()).routeParam("keyId", keyId.toString()).asJson();
    }

    public List<String> getBranches(String sourceRepositoryPath) throws Exception {
        ArrayList<String> branches = new ArrayList<String>();
        for (GitlabBranch gitlabBranch : this.gitlabService.getUserClient().getBranches(this.gitlabService.getProjectFromPath(sourceRepositoryPath))) {
            branches.add(gitlabBranch.getName());
        }
        for (GitlabTag tag : this.gitlabService.getUserClient().getTags(this.gitlabService.getProjectFromPath(sourceRepositoryPath))) {
            branches.add(tag.getName());
        }
        return branches;
    }

    public List<SourceRepositoryCommit> getCommits(String sourceRepositoryPath, String branch) throws Exception {
        ArrayList<SourceRepositoryCommit> commits = new ArrayList<SourceRepositoryCommit>();
        for (GitlabCommit gitlabCommit : this.gitlabService.getUserClient().getAllCommits((Serializable)this.gitlabService.getProjectFromPath(sourceRepositoryPath).getId(), branch)) {
            commits.add(this.getSourceRepositoryCommitFromGitlabCommit(gitlabCommit));
        }
        return commits;
    }

    public FileDataSource getFile(String sourceRepositoryPath, String branch, String filepath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)sourceRepositoryPath) || StringUtils.isEmpty((CharSequence)branch) || StringUtils.isEmpty((CharSequence)filepath)) {
            throw new IllegalArgumentException("sourceRepositoryPath, branch and filepath must be specified");
        }
        GitlabProject project = this.getGitlabProject(sourceRepositoryPath);
        String projectName = project.getName();
        File workingFolder = this.gitService.createWorkingFolder();
        CredentialsProvider cp = this.getCredentialProviders();
        this.gitService.cloneProject(projectName, branch, workingFolder, cp, project.getHttpUrl(), true);
        File file = new File(workingFolder, File.separator + projectName + File.separator + filepath);
        if (file == null || !file.exists() || file.isDirectory()) {
            throw new NotFoundException("File " + filepath + " not found in repository " + sourceRepositoryPath + " ,branch=" + branch);
        }
        return new FileDataSource(file);
    }

    public Folder getFolder(String folderPath) throws Exception {
        return null;
    }

    public List<Folder> getFolders() throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        List gitlabGroups = this.gitlabService.getUserClient().getGroups();
        for (GitlabGroup g : gitlabGroups) {
            folders.add(new Folder().path(g.getFullPath()));
        }
        return folders;
    }

    public List<SourceRepository> getSourceRepositoriesInFolder(String folderPath) throws Exception {
        List groupProjects;
        try {
            groupProjects = this.gitlabService.getUserClient().getGroupProjects(this.gitlabService.getAdminClient().getGroup(folderPath).getId());
        }
        catch (Error e) {
            throw new ApiException(404, "This group doesn't exists");
        }
        ArrayList<SourceRepository> repos = new ArrayList<SourceRepository>();
        groupProjects.forEach(p -> {
            SourceRepository sourceRepository = new SourceRepository();
            sourceRepository.providerId(p.getId().toString()).name(p.getName());
            sourceRepository.provider("gitlab").httpUrl(p.getHttpUrl()).webUrl(p.getWebUrl()).sshUrl(p.getSshUrl());
            repos.add(sourceRepository);
        });
        return repos;
    }

    public ApiResponse addMemberships(List<Membership> memberships) throws Exception {
        this.gitlabService.addMemberships(memberships);
        return new ApiResponse(200, null, (Object)"Successfully added members");
    }

    public ApiResponse createDeployKey(String keyName, String sshPublicKey, String sourceRepositoryPath) throws Exception {
        try {
            this.gitlabService.createDeployKey(keyName, sshPublicKey, sourceRepositoryPath);
        }
        catch (GitlabAPIException e) {
            throw new ApiException(e.getResponseCode(), e.getMessage());
        }
        return new ApiResponse(200, null, (Object)("Successfully added deploy key " + keyName));
    }

    public ApiResponse deleteMemberships(List<Membership> memberships) throws Exception {
        this.gitlabService.deleteMemberships(memberships);
        return new ApiResponse(200, null, (Object)"Successfully removed members");
    }

    public List<Membership> getMemberships(String sourceRepositoryPath, String memberType) throws Exception {
        return this.gitlabService.getMemberships(sourceRepositoryPath, memberType);
    }

    private SourceRepositoryCommit getSourceRepositoryCommitFromGitlabCommit(GitlabCommit gitlabCommit) {
        SourceRepositoryCommit commit = new SourceRepositoryCommit().authorEmail(gitlabCommit.getAuthorEmail()).authorName(gitlabCommit.getAuthorName()).createdAt(gitlabCommit.getCreatedAt().toString()).message(gitlabCommit.getMessage()).shortId(gitlabCommit.getShortId()).title(gitlabCommit.getTitle());
        commit.id(gitlabCommit.getId());
        return commit;
    }

    private String getGroupPathFromWebUrl(String webUrl) {
        return webUrl.split("groups/")[1];
    }

    private Folder convertGitlabGroupToFolder(GitlabGroup g) {
        Folder folder = new Folder().path(this.getGroupPathFromWebUrl(g.getWebUrl()));
        return folder;
    }

    public GitlabService getGitlabService() {
        return this.gitlabService;
    }

    private GitlabGroup createFolderHierarchyIfNotExists(Path path) throws Exception {
        GitlabGroup currentFolder = this.checkExistingFolder(path);
        if (currentFolder != null) {
            if (currentFolder.getFullPath().equals(path.toString())) {
                return currentFolder;
            }
            path = Paths.get(currentFolder.getFullPath(), new String[0]).relativize(path);
        }
        Iterator<Path> iterator = path.iterator();
        while (iterator.hasNext()) {
            currentFolder = this.createFolderIfNotExists(iterator.next().toString(), currentFolder);
        }
        return currentFolder;
    }

    private GitlabGroup checkExistingFolder(Path path) {
        Path pathToTest = path;
        GitlabGroup ret = null;
        while (pathToTest != null && ret == null) {
            try {
                ret = this.gitlabService.getUserClient().getGroup(pathToTest.toString());
            }
            catch (IOException e) {
                pathToTest = pathToTest.getParent();
            }
        }
        return ret;
    }

    private synchronized GitlabGroup createFolderIfNotExists(String folderName, GitlabGroup parentGroup) throws Exception {
        GitlabGroup groupFolder;
        block6: {
            groupFolder = null;
            try {
                if (parentGroup != null) {
                    CreateGroupRequest groupRequest = new CreateGroupRequest(folderName).setParentId(parentGroup.getId());
                    groupFolder = this.gitlabService.getUserClient().createGroup(groupRequest, null);
                } else {
                    groupFolder = this.gitlabService.getUserClient().createGroup(folderName);
                }
            }
            catch (GitlabAPIException e) {
                if (e.getResponseCode() == 400) {
                    groupFolder = parentGroup != null ? this.gitlabService.getUserClient().getGroup(parentGroup.getFullPath() + "/" + folderName) : this.gitlabService.getUserClient().getGroup(folderName);
                    return groupFolder;
                }
                if (e.getResponseCode() != 403) break block6;
                if (parentGroup != null) {
                    throw new KathraException("Forbidden to create folder " + parentGroup.getFullPath() + "/" + folderName + ", please verify you have the correct permissions in your source repository provider", e.getCause(), KathraException.ErrorCode.FORBIDDEN);
                }
                throw new KathraException("Forbidden to create folder " + folderName + ", please verify you have the correct permissions in your source repository provider", e.getCause(), KathraException.ErrorCode.FORBIDDEN);
            }
        }
        return groupFolder;
    }

    private CredentialsProvider getCredentialProviders() {
        String username = this.gitlabService.session.getCallerName();
        String impersonationTokenForUser = this.gitlabService.getImpersonationTokenForUser();
        return new UsernamePasswordCredentialsProvider(username, impersonationTokenForUser);
    }

    private GitlabProject getGitlabProject(String sourceRepositoryPath) throws Exception {
        GitlabProject projectFromPath = this.gitlabService.getProjectFromPath(sourceRepositoryPath);
        GitlabProject project = this.gitlabService.getUserClient().getProject((Serializable)projectFromPath.getId());
        if (!project.getPathWithNamespace().startsWith(this.config.getKathraRootGroup())) {
            throw new KathraException("Unauthorized to read from a non-kathra source repository").errorCode(KathraException.ErrorCode.UNAUTHORIZED);
        }
        return project;
    }

    private File tmpFileToPermanentFile(File file, String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileName) || fileName.equals(".")) {
            String[] split = file.getName().split("_");
            fileName = split[split.length - 1];
        }
        File tmpFile = new File(file.getParentFile().getPath() + File.separator + "SourceManager-Gitlab" + file.getName() + File.separator + fileName);
        FileUtils.copyFile((File)file, (File)tmpFile);
        return tmpFile;
    }
}

