/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.usermanager;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.kathra.KathraAuthRequestHandlerImpl;
import org.kathra.core.model.Group;
import org.kathra.core.model.User;
import org.kathra.utils.security.KeycloakUtils;

@ContextName(value="UserManager")
public class UserManagerApi
extends RouteBuilder {
    public void configure() throws Exception {
        KeycloakUtils.init();
        this.restConfiguration().component("netty4-http").bindingMode(RestBindingMode.off).dataFormatProperty("prettyPrint", "true").dataFormatProperty("json.in.disableFeatures", "FAIL_ON_UNKNOWN_PROPERTIES").contextPath("/api/v1").port("{{env:HTTP_PORT:8080}}").apiContextPath("/swagger.json").apiProperty("api.title", "Kathra Users Management API").apiProperty("api.version", "1.0.0-RC-SNAPSHOT").apiProperty("api.description", "UserManager").apiProperty("cors", "true").enableCORS(true).corsAllowCredentials(true).corsHeaderProperty("Access-Control-Allow-Headers", "Origin, Accept, X-Requested-With, Content-Type,Access-Control-Request-Method, Access-Control-Request-Headers, Authorization");
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.rest().post("/groups").outType(Group.class).description("Create a new group").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=createGroup").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/users").outType(User.class).description("Create a new user").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=createUser").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/groups/{groupPath}").outType(Group.class).description("Return group object").param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getGroup(${header.groupPath})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/groups").outType(Group[].class).description("Find all groups").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getGroups").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/users/{userId}").outType(User.class).description("Return user object").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getUser(${header.userId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/users").outType(User[].class).description("Find all users").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getUsers").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest();
    }
}

