/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.usermanager;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.kathra.KathraAuthRequestHandlerImpl;
import org.kathra.core.model.Group;
import org.kathra.core.model.User;
import org.kathra.utils.security.KeycloakUtils;

@ContextName(value="UserManager")
public class UserManagerApi
extends RouteBuilder {
    public void configure() throws Exception {
        KeycloakUtils.init();
        this.restConfiguration().component("netty4-http").bindingMode(RestBindingMode.off).dataFormatProperty("prettyPrint", "true").dataFormatProperty("json.in.disableFeatures", "FAIL_ON_UNKNOWN_PROPERTIES").contextPath("/api/v1").port("{{env:HTTP_PORT:8080}}").componentProperty("chunkedMaxContentLength", String.valueOf(1468006400)).endpointProperty("chunkedMaxContentLength", String.valueOf(1468006400)).consumerProperty("chunkedMaxContentLength", String.valueOf(1468006400)).apiContextPath("/swagger.json").apiProperty("api.title", "Kathra Users Management API").apiProperty("api.version", "1.1.0-SNAPSHOT").apiProperty("api.description", "UserManager").apiProperty("cors", "true").enableCORS(true).corsAllowCredentials(true).corsHeaderProperty("Access-Control-Allow-Headers", "Origin, Accept, X-Requested-With, Content-Type,Access-Control-Request-Method, Access-Control-Request-Headers, Authorization");
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.rest().post("/users/{userId}/joinGroup/{groupPath}").outType(User.class).description("Assign user to group").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=assignUserToGroup(${header.userId},${header.groupPath})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/groups").type(Group.class).outType(Group.class).description("Create a new group").param().required(Boolean.valueOf(true)).name("group").type(RestParamType.body).description("Group object to be created").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, Group.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=createGroup(${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/users").type(User.class).outType(User.class).description("Create a new user").param().required(Boolean.valueOf(true)).name("user").type(RestParamType.body).description("User object to be created").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, User.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=createUser(${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/groups/{groupPath}").outType(Group.class).description("Delete group").param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=deleteGroup(${header.groupPath})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/users/{userId}").outType(User.class).description("Delete user").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=deleteUser(${header.userId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/groups/{groupPath}").outType(Group.class).description("Return group").param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getGroup(${header.groupPath})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/groups").outType(Group[].class).description("Find all groups").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getGroups").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/users/{userId}/groupsMembers").outType(Group[].class).description("Return groups from user").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getGroupsAssignationsFromUser(${header.userId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/users/{userId}").outType(User.class).description("Return user").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getUser(${header.userId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/users").outType(User[].class).description("Find all users").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=getUsers").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().patch("/groups/{groupPath}").type(Group.class).outType(Group.class).description("Patch group").param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().param().required(Boolean.valueOf(true)).name("group").type(RestParamType.body).description("Group object to be created").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, Group.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=patchGroup(${header.groupPath},${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().patch("/users/{userId}").type(User.class).outType(User.class).description("Patch user").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().param().required(Boolean.valueOf(true)).name("user").type(RestParamType.body).description("User object to be patched").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, User.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=patchUser(${header.userId},${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/users/{userId}/quitGroup/{groupPath}").outType(User.class).description("Unassign user to group").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=unassignUserToGroup(${header.userId},${header.groupPath})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().put("/groups/{groupPath}").type(Group.class).outType(Group.class).description("Update group").param().required(Boolean.valueOf(true)).dataType("string").name("groupPath").type(RestParamType.path).description("Group Path").endParam().param().required(Boolean.valueOf(true)).name("group").type(RestParamType.body).description("Group object to be created").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, Group.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=updateGroup(${header.groupPath},${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().put("/users/{userId}").type(User.class).outType(User.class).description("Update user").param().required(Boolean.valueOf(true)).dataType("string").name("userId").type(RestParamType.path).description("User id").endParam().param().required(Boolean.valueOf(true)).name("user").type(RestParamType.body).description("User object to be updated").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, User.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:UserManagerController?method=updateUser(${header.userId},${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest();
    }
}

