/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.usermanager.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.kathra.core.model.Assignation;
import org.kathra.core.model.Group;
import org.kathra.core.model.User;
import org.kathra.usermanager.Config;
import org.kathra.usermanager.service.UserManagerService;
import org.kathra.usermanager.services.KeycloakService;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

@Named(value="UserManagerController")
@ContextName(value="UserManager")
public class UserManagerController
implements UserManagerService {
    private Config config = new Config();
    KeycloakService keycloakService = new KeycloakService(this.config.getKeycloakAuthUrl(), this.config.getKeycloakRealm(), this.config.getKeycloakClientId(), this.config.getKeycloakClientSecret());

    private void populateGroup(List<Group> groups, List<GroupRepresentation> subGroups) {
        subGroups.forEach(subGroupRepresentation -> {
            Group group = new Group().id(subGroupRepresentation.getId()).name(subGroupRepresentation.getName()).path(subGroupRepresentation.getPath());
            List<UserRepresentation> members = this.keycloakService.getGroupMembers(group.getId());
            for (UserRepresentation member : members) {
                Assignation userAssignation = new Assignation().id(member.getId()).name(member.getUsername());
                if (group.getMembers() != null && group.getMembers().contains(userAssignation)) continue;
                group.addMembersItem(userAssignation);
            }
            groups.add(group);
            if (subGroupRepresentation.getSubGroups() != null) {
                this.populateGroup(groups, subGroupRepresentation.getSubGroups());
            }
        });
    }

    public Group createGroup() throws Exception {
        return null;
    }

    public User createUser() throws Exception {
        return null;
    }

    public Group getGroup(String groupPath) throws Exception {
        return null;
    }

    public List<Group> getGroups() throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        List<GroupRepresentation> subGroups = this.keycloakService.getGroups();
        this.populateGroup(groups, subGroups);
        return groups;
    }

    public User getUser(String userId) throws Exception {
        return null;
    }

    public List<User> getUsers() throws Exception {
        return null;
    }
}

