/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.usermanager.services;

import java.util.List;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class KeycloakService {
    private Keycloak keycloak;
    RealmResource kathraRealm;

    public KeycloakService(String url, String realm, String clientId, String clientSecret) {
        this.keycloak = KeycloakBuilder.builder().serverUrl(url).grantType("client_credentials").realm(realm).clientId(clientId).clientSecret(clientSecret).build();
        this.kathraRealm = this.keycloak.realm(realm);
    }

    public List<UserRepresentation> getGroupMembers(String groupId) {
        GroupResource groupResource = this.kathraRealm.groups().group(groupId);
        return groupResource.members(Integer.valueOf(0), Integer.valueOf(1000));
    }

    public List<GroupRepresentation> getGroups() {
        GroupResource kathraRootGroup = this.kathraRealm.groups().group(this.kathraRealm.getGroupByPath("kathra-projects").getId());
        return kathraRootGroup.toRepresentation().getSubGroups();
    }
}

