/* 
 * Copyright 2019 The Kathra Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *
 *    IRT SystemX (https://www.kathra.org/)    
 *
 */
package org.kathra.usermanager.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
* Assignation
*/
@ApiModel(description = "Assignation")
public class Assignation {

    protected String id = null;
    protected String role = null;
    protected String fte = null;

    /**
    * Quick Set id
    * Useful setter to use in builder style (eg. myAssignation.id(String).anotherQuickSetter(..))
    * @param String id
    * @return Assignation The modified Assignation object
    **/
    public Assignation id(String id) {
        this.id = id;
        return this;
    }

    /**
    * id
    * @return String id
    **/
    @ApiModelProperty(value = "id")
    public String getId() {
        return id;
    }

    /**
    * id
    **/
    public void setId(String id) {
        this.id = id;
    }

    /**
    * Quick Set role
    * Useful setter to use in builder style (eg. myAssignation.role(String).anotherQuickSetter(..))
    * @param String role
    * @return Assignation The modified Assignation object
    **/
    public Assignation role(String role) {
        this.role = role;
        return this;
    }

    /**
    * role
    * @return String role
    **/
    @ApiModelProperty(value = "role")
    public String getRole() {
        return role;
    }

    /**
    * role
    **/
    public void setRole(String role) {
        this.role = role;
    }

    /**
    * Quick Set fte
    * Useful setter to use in builder style (eg. myAssignation.fte(String).anotherQuickSetter(..))
    * @param String fte
    * @return Assignation The modified Assignation object
    **/
    public Assignation fte(String fte) {
        this.fte = fte;
        return this;
    }

    /**
    * fte
    * @return String fte
    **/
    @ApiModelProperty(value = "fte")
    public String getFte() {
        return fte;
    }

    /**
    * fte
    **/
    public void setFte(String fte) {
        this.fte = fte;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Assignation assignation = (Assignation) o;
        return Objects.equals(this.id, assignation.id) &&
        Objects.equals(this.role, assignation.role) &&
        Objects.equals(this.fte, assignation.fte);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, role, fte);
    }
}

