/* 
 * Copyright 2019 The Kathra Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *
 *    IRT SystemX (https://www.kathra.org/)    
 *
 */
package org.kathra.usermanager.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
* Department
*/
@ApiModel(description = "Department")
public class Department {

    protected String id = null;
    protected String name = null;
    protected String fullName = null;
    protected List<Assignation> members = null;
    protected List<Project> projects = null;

    /**
    * Quick Set id
    * Useful setter to use in builder style (eg. myDepartment.id(String).anotherQuickSetter(..))
    * @param String id
    * @return Department The modified Department object
    **/
    public Department id(String id) {
        this.id = id;
        return this;
    }

    /**
    * id
    * @return String id
    **/
    @ApiModelProperty(value = "id")
    public String getId() {
        return id;
    }

    /**
    * id
    **/
    public void setId(String id) {
        this.id = id;
    }

    /**
    * Quick Set name
    * Useful setter to use in builder style (eg. myDepartment.name(String).anotherQuickSetter(..))
    * @param String name
    * @return Department The modified Department object
    **/
    public Department name(String name) {
        this.name = name;
        return this;
    }

    /**
    * name
    * @return String name
    **/
    @ApiModelProperty(value = "name")
    public String getName() {
        return name;
    }

    /**
    * name
    **/
    public void setName(String name) {
        this.name = name;
    }

    /**
    * Quick Set fullName
    * Useful setter to use in builder style (eg. myDepartment.fullName(String).anotherQuickSetter(..))
    * @param String fullName
    * @return Department The modified Department object
    **/
    public Department fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    /**
    * fullName
    * @return String fullName
    **/
    @ApiModelProperty(value = "fullName")
    public String getFullName() {
        return fullName;
    }

    /**
    * fullName
    **/
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
    * Quick Set members
    * Useful setter to use in builder style (eg. myDepartment.members(List<Assignation>).anotherQuickSetter(..))
    * @param List<Assignation> members
    * @return Department The modified Department object
    **/
    public Department members(List<Assignation> members) {
        this.members = members;
        return this;
    }

    public Department addMembersItem(Assignation membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<Assignation>();
        }
        this.members.add(membersItem);
        return this;
    }

    /**
    * members
    * @return List<Assignation> members
    **/
    @ApiModelProperty(value = "members")
    public List<Assignation> getMembers() {
        return members;
    }

    /**
    * members
    **/
    public void setMembers(List<Assignation> members) {
        this.members = members;
    }

    /**
    * Quick Set projects
    * Useful setter to use in builder style (eg. myDepartment.projects(List<Project>).anotherQuickSetter(..))
    * @param List<Project> projects
    * @return Department The modified Department object
    **/
    public Department projects(List<Project> projects) {
        this.projects = projects;
        return this;
    }

    public Department addProjectsItem(Project projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    /**
    * projects
    * @return List<Project> projects
    **/
    @ApiModelProperty(value = "projects")
    public List<Project> getProjects() {
        return projects;
    }

    /**
    * projects
    **/
    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Department department = (Department) o;
        return Objects.equals(this.id, department.id) &&
        Objects.equals(this.name, department.name) &&
        Objects.equals(this.fullName, department.fullName) &&
        Objects.equals(this.members, department.members) &&
        Objects.equals(this.projects, department.projects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, fullName, members, projects);
    }
}

