/* 
 * Copyright 2019 The Kathra Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *
 *    IRT SystemX (https://www.kathra.org/)    
 *
 */
package org.kathra.usermanager.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
* Project
*/
@ApiModel(description = "Project")
public class Project {

    protected String id = null;
    protected String name = null;
    protected String fullName = null;
    protected String department = null;
    protected List<Assignation> members = null;

    /**
    * Quick Set id
    * Useful setter to use in builder style (eg. myProject.id(String).anotherQuickSetter(..))
    * @param String id
    * @return Project The modified Project object
    **/
    public Project id(String id) {
        this.id = id;
        return this;
    }

    /**
    * id
    * @return String id
    **/
    @ApiModelProperty(value = "id")
    public String getId() {
        return id;
    }

    /**
    * id
    **/
    public void setId(String id) {
        this.id = id;
    }

    /**
    * Quick Set name
    * Useful setter to use in builder style (eg. myProject.name(String).anotherQuickSetter(..))
    * @param String name
    * @return Project The modified Project object
    **/
    public Project name(String name) {
        this.name = name;
        return this;
    }

    /**
    * name
    * @return String name
    **/
    @ApiModelProperty(value = "name")
    public String getName() {
        return name;
    }

    /**
    * name
    **/
    public void setName(String name) {
        this.name = name;
    }

    /**
    * Quick Set fullName
    * Useful setter to use in builder style (eg. myProject.fullName(String).anotherQuickSetter(..))
    * @param String fullName
    * @return Project The modified Project object
    **/
    public Project fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    /**
    * fullName
    * @return String fullName
    **/
    @ApiModelProperty(value = "fullName")
    public String getFullName() {
        return fullName;
    }

    /**
    * fullName
    **/
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
    * Quick Set department
    * Useful setter to use in builder style (eg. myProject.department(String).anotherQuickSetter(..))
    * @param String department
    * @return Project The modified Project object
    **/
    public Project department(String department) {
        this.department = department;
        return this;
    }

    /**
    * department
    * @return String department
    **/
    @ApiModelProperty(value = "department")
    public String getDepartment() {
        return department;
    }

    /**
    * department
    **/
    public void setDepartment(String department) {
        this.department = department;
    }

    /**
    * Quick Set members
    * Useful setter to use in builder style (eg. myProject.members(List<Assignation>).anotherQuickSetter(..))
    * @param List<Assignation> members
    * @return Project The modified Project object
    **/
    public Project members(List<Assignation> members) {
        this.members = members;
        return this;
    }

    public Project addMembersItem(Assignation membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<Assignation>();
        }
        this.members.add(membersItem);
        return this;
    }

    /**
    * members
    * @return List<Assignation> members
    **/
    @ApiModelProperty(value = "members")
    public List<Assignation> getMembers() {
        return members;
    }

    /**
    * members
    **/
    public void setMembers(List<Assignation> members) {
        this.members = members;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project) o;
        return Objects.equals(this.id, project.id) &&
        Objects.equals(this.name, project.name) &&
        Objects.equals(this.fullName, project.fullName) &&
        Objects.equals(this.department, project.department) &&
        Objects.equals(this.members, project.members);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, fullName, department, members);
    }
}

