/* 
 * Copyright 2019 The Kathra Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *
 *    IRT SystemX (https://www.kathra.org/)    
 *
 */
package org.kathra.usermanager.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
* User
*/
@ApiModel(description = "User")
public class User {

    protected String id = null;
    protected String username = null;
    protected String firstName = null;
    protected String lastName = null;
    protected String email = null;
    protected String password = null;
    protected String phone = null;
    protected List<Assignation> projects = null;

    /**
    * Quick Set id
    * Useful setter to use in builder style (eg. myUser.id(String).anotherQuickSetter(..))
    * @param String id
    * @return User The modified User object
    **/
    public User id(String id) {
        this.id = id;
        return this;
    }

    /**
    * id
    * @return String id
    **/
    @ApiModelProperty(value = "id")
    public String getId() {
        return id;
    }

    /**
    * id
    **/
    public void setId(String id) {
        this.id = id;
    }

    /**
    * Quick Set username
    * Useful setter to use in builder style (eg. myUser.username(String).anotherQuickSetter(..))
    * @param String username
    * @return User The modified User object
    **/
    public User username(String username) {
        this.username = username;
        return this;
    }

    /**
    * username
    * @return String username
    **/
    @ApiModelProperty(value = "username")
    public String getUsername() {
        return username;
    }

    /**
    * username
    **/
    public void setUsername(String username) {
        this.username = username;
    }

    /**
    * Quick Set firstName
    * Useful setter to use in builder style (eg. myUser.firstName(String).anotherQuickSetter(..))
    * @param String firstName
    * @return User The modified User object
    **/
    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    /**
    * firstName
    * @return String firstName
    **/
    @ApiModelProperty(value = "firstName")
    public String getFirstName() {
        return firstName;
    }

    /**
    * firstName
    **/
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
    * Quick Set lastName
    * Useful setter to use in builder style (eg. myUser.lastName(String).anotherQuickSetter(..))
    * @param String lastName
    * @return User The modified User object
    **/
    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    /**
    * lastName
    * @return String lastName
    **/
    @ApiModelProperty(value = "lastName")
    public String getLastName() {
        return lastName;
    }

    /**
    * lastName
    **/
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /**
    * Quick Set email
    * Useful setter to use in builder style (eg. myUser.email(String).anotherQuickSetter(..))
    * @param String email
    * @return User The modified User object
    **/
    public User email(String email) {
        this.email = email;
        return this;
    }

    /**
    * email
    * @return String email
    **/
    @ApiModelProperty(value = "email")
    public String getEmail() {
        return email;
    }

    /**
    * email
    **/
    public void setEmail(String email) {
        this.email = email;
    }

    /**
    * Quick Set password
    * Useful setter to use in builder style (eg. myUser.password(String).anotherQuickSetter(..))
    * @param String password
    * @return User The modified User object
    **/
    public User password(String password) {
        this.password = password;
        return this;
    }

    /**
    * password
    * @return String password
    **/
    @ApiModelProperty(value = "password")
    public String getPassword() {
        return password;
    }

    /**
    * password
    **/
    public void setPassword(String password) {
        this.password = password;
    }

    /**
    * Quick Set phone
    * Useful setter to use in builder style (eg. myUser.phone(String).anotherQuickSetter(..))
    * @param String phone
    * @return User The modified User object
    **/
    public User phone(String phone) {
        this.phone = phone;
        return this;
    }

    /**
    * phone
    * @return String phone
    **/
    @ApiModelProperty(value = "phone")
    public String getPhone() {
        return phone;
    }

    /**
    * phone
    **/
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
    * Quick Set projects
    * Useful setter to use in builder style (eg. myUser.projects(List<Assignation>).anotherQuickSetter(..))
    * @param List<Assignation> projects
    * @return User The modified User object
    **/
    public User projects(List<Assignation> projects) {
        this.projects = projects;
        return this;
    }

    public User addProjectsItem(Assignation projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Assignation>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    /**
    * projects
    * @return List<Assignation> projects
    **/
    @ApiModelProperty(value = "projects")
    public List<Assignation> getProjects() {
        return projects;
    }

    /**
    * projects
    **/
    public void setProjects(List<Assignation> projects) {
        this.projects = projects;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        User user = (User) o;
        return Objects.equals(this.id, user.id) &&
        Objects.equals(this.username, user.username) &&
        Objects.equals(this.firstName, user.firstName) &&
        Objects.equals(this.lastName, user.lastName) &&
        Objects.equals(this.email, user.email) &&
        Objects.equals(this.password, user.password) &&
        Objects.equals(this.phone, user.phone) &&
        Objects.equals(this.projects, user.projects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, username, firstName, lastName, email, password, phone, projects);
    }
}

