/*
 * Decompiled with CFR 0.152.
 */
package org.kathrynhuxtable.maven.plugins.docbkxwrapper;

import com.agilejava.docbkx.maven.DocbkxXhtmlMojo;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.kathrynhuxtable.maven.plugins.htmlfiltersite.MergeMojo;

public class GenerateMojo
extends AbstractMojo {
    private File templateFile;
    private File basedir;
    private File projectBuildDirectory;
    protected List<?> repositories;
    protected ArtifactRepository localRepository;
    protected MavenProject project;
    protected List<?> reactorProjects;
    private SiteTool siteTool;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generateXhtml();
        this.mergeFiles();
    }

    private void generateXhtml() throws MojoFailureException, MojoExecutionException {
        DocbkxXhtmlMojo docbkxMojo = new DocbkxXhtmlMojo();
        docbkxMojo.setLog(this.getLog());
        this.setValue(docbkxMojo, "sourceDirectory", new File(this.basedir, "src/site/docbook"));
        this.setValue(docbkxMojo, "includes", "**/*.xml,**/*.xml.vm");
        this.setValue(docbkxMojo, "targetDirectory", new File(this.projectBuildDirectory, "generated-site/docbook-xhtml"));
        this.setValue(docbkxMojo, "xhtmlCustomization", "/org/kathrynhuxtable/maven/plugins/docbkxwrapper/xsl/html.xsl");
        this.setValue(docbkxMojo, "targetFileExtension", "html");
        this.setValue(docbkxMojo, "imgSrcPath", "./");
        this.setValue(docbkxMojo, "generateMetaAbstract", "false");
        this.setValue(docbkxMojo, "generateToc", "false");
        this.setValue(docbkxMojo, "highlightSource", "true");
        this.setValue(docbkxMojo, "highlightDefaultLanguage", null);
        this.setValue(docbkxMojo, "suppressHeaderNavigation", "true");
        this.setValue(docbkxMojo, "suppressFooterNavigation", "true");
        this.setValue(docbkxMojo, "tableBordersWithCss", "true");
        this.setValue(docbkxMojo, "tableFrameBorderThickness", "0");
        this.setValue(docbkxMojo, "tableCellBorderThickness", "0");
        this.setValue(docbkxMojo, "useExtensions", "true");
        this.setValue(docbkxMojo, "calloutsExtension", "true");
        docbkxMojo.execute();
    }

    private void mergeFiles() throws MojoFailureException, MojoExecutionException {
        MergeMojo mergeMojo = new MergeMojo();
        mergeMojo.setLog(this.getLog());
        this.setValue(mergeMojo, "sourceDirectory", new File(this.projectBuildDirectory, "generated-site/docbook-xhtml"));
        this.setValue(mergeMojo, "filePattern", "**/*.html,**/*.xm.html");
        this.setValue(mergeMojo, "filterExtension", ".xm.html");
        this.setValue(mergeMojo, "targetDirectory", new File(this.projectBuildDirectory, "generated-site/resources"));
        this.setValue(mergeMojo, "templateFile", this.templateFile);
        this.setValue(mergeMojo, "siteDirectory", new File(this.basedir, "src/site"));
        this.setValue(mergeMojo, "repositories", this.repositories);
        this.setValue(mergeMojo, "localRepository", this.localRepository);
        this.setValue(mergeMojo, "project", this.project);
        this.setValue(mergeMojo, "reactorProjects", this.reactorProjects);
        this.setValue(mergeMojo, "siteTool", this.siteTool);
        mergeMojo.execute();
    }

    private void setValue(Object o, String fieldName, Object value) throws MojoFailureException {
        Class<?> c = o.getClass();
        try {
            Field field = c.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException(e.getMessage());
        }
    }
}

